/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.query;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.collections.ImmutableSortedSet;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.java7.Streams;
import com.pushtechnology.diffusion.timeseries.event.EventImpl;
import com.pushtechnology.diffusion.timeseries.event.EventMetadataImpl;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryResult;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="range-query-result", valueType=RangeQueryResult.class)
public class RangeQueryResultSerialiser
extends AbstractSerialiser<RangeQueryResult> {
    private final DataTypes dataTypes;
    private static final byte ORIGINAL_EVENT = 0;
    private static final byte EDIT_EVENT = 1;
    private static final byte METADATA_OFFSETS = 2;
    private static final byte AUTHOR_ENCODING = 3;

    public RangeQueryResultSerialiser(DataTypes dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public void write(OutputStream out, RangeQueryResult value) throws IOException {
        EncodedDataCodec.writeString(out, value.valueDataType().getTypeName());
        EncodedDataCodec.writeInt64(out, value.selectedCount());
        List<TimeSeries.Event<IBytes>> events = value.events();
        if (events.isEmpty()) {
            EncodedDataCodec.writeInt32(out, 0);
            return;
        }
        Minimums minimums = RangeQueryResultSerialiser.calculateMinimums(events);
        Offsets offsets = minimums.offsets();
        ImmutableSortedSet<String> repeatAuthors = minimums.repeatAuthors();
        EncodedDataCodec.writeInt32(out, events.size() + 1 + repeatAuthors.size());
        Map<String, byte[]> authorToCode = RangeQueryResultSerialiser.writeAuthorEncodings(out, repeatAuthors);
        RangeQueryResultSerialiser.writeMetadataOffsets(out, offsets);
        for (TimeSeries.Event<IBytes> e : events) {
            if (e.isEditEvent()) {
                EncodedDataCodec.writeByte(out, (byte)1);
                RangeQueryResultSerialiser.writeMetadata(out, e.originalEvent(), offsets, authorToCode);
            } else {
                EncodedDataCodec.writeByte(out, (byte)0);
            }
            RangeQueryResultSerialiser.writeMetadata(out, e, offsets, authorToCode);
            IBytes bytes = e.value();
            EncodedDataCodec.writeInt32(out, bytes.length());
            bytes.copyTo(out);
        }
    }

    @Override
    protected RangeQueryResult readUnchecked(InputStream in) throws IOException {
        DataType<?> valueDataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        long selectedCount = RangeQueryResultSerialiser.checkNonNegative(EncodedDataCodec.readInt64(in), "selectedCount");
        Offsets offsets = new Offsets(0L, 0L);
        HashMap<IBytes, String> codeToAuthor = new HashMap<IBytes, String>();
        int n = EncodedDataCodec.readInt32(in);
        if (n < 0) {
            throw new IOException("Negative entry length: " + n);
        }
        ArrayList<TimeSeries.Event<IBytes>> events = new ArrayList<TimeSeries.Event<IBytes>>(n);
        block6: for (int i = 0; i < n; ++i) {
            byte b = EncodedDataCodec.readByte(in);
            switch (b) {
                case 0: {
                    events.add(RangeQueryResultSerialiser.readOriginalEvent(in, offsets, codeToAuthor));
                    continue block6;
                }
                case 1: {
                    events.add(RangeQueryResultSerialiser.readEditEvent(in, offsets, codeToAuthor));
                    continue block6;
                }
                case 2: {
                    offsets = RangeQueryResultSerialiser.readMetadataOffsets(in);
                    continue block6;
                }
                case 3: {
                    RangeQueryResultSerialiser.readAuthorEncoding(in, codeToAuthor);
                    continue block6;
                }
                default: {
                    throw new IOException("Invalid event type: " + b);
                }
            }
        }
        return new RangeQueryResult(valueDataType, selectedCount, events);
    }

    private static long checkNonNegative(long n, String what) throws IOException {
        if (n < 0L) {
            throw new IOException("Negative " + what + ": " + n);
        }
        return n;
    }

    private static EventImpl<IBytes> readOriginalEvent(InputStream in, Offsets offsets, Map<IBytes, String> codeToAuthor) throws IOException {
        EventMetadataImpl metadata = RangeQueryResultSerialiser.readMetadata(in, offsets, codeToAuthor);
        return EventImpl.createEvent(metadata, metadata, IBytes.toIBytes(EncodedDataCodec.readByteArray(in)));
    }

    private static EventImpl<IBytes> readEditEvent(InputStream in, Offsets offsets, Map<IBytes, String> codeToAuthor) throws IOException {
        EventMetadataImpl originalEvent = RangeQueryResultSerialiser.readMetadata(in, offsets, codeToAuthor);
        EventMetadataImpl metadata = RangeQueryResultSerialiser.readMetadata(in, offsets, codeToAuthor);
        return EventImpl.createEvent(metadata, originalEvent, IBytes.toIBytes(EncodedDataCodec.readByteArray(in)));
    }

    private static void writeMetadata(OutputStream out, TimeSeries.EventMetadata value, Offsets offsets, Map<String, byte[]> authorToCode) throws IOException {
        EncodedDataCodec.writeInt64(out, value.sequence() - offsets.sequence());
        EncodedDataCodec.writeInt64(out, value.timestamp() - offsets.timestamp());
        byte[] code = authorToCode.get(value.author());
        if (code != null) {
            EncodedDataCodec.writeByteArray(out, code);
        } else {
            EncodedDataCodec.writeString(out, value.author());
        }
    }

    private static EventMetadataImpl readMetadata(InputStream in, Offsets offsets, Map<IBytes, String> codeToAuthor) throws IOException {
        long sequence = RangeQueryResultSerialiser.addExactIO(EncodedDataCodec.readInt64(in), offsets.sequence());
        long timestamp = EncodedDataCodec.readInt64(in) + offsets.timestamp();
        byte[] code = EncodedDataCodec.readByteArray(in);
        String decoded = codeToAuthor.get(IBytes.toIBytes(code));
        String author = decoded != null ? decoded : CharsetUtils.bytesUTF8ToString(code);
        return new EventMetadataImpl(sequence, timestamp, author);
    }

    private static long addExactIO(long x, long y) throws IOException {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw new IOException(new ArithmeticException("long overflow"));
        }
        return r;
    }

    private static void writeMetadataOffsets(OutputStream out, Offsets offsets) throws IOException {
        EncodedDataCodec.writeByte(out, (byte)2);
        EncodedDataCodec.writeInt64(out, offsets.sequence());
        EncodedDataCodec.writeInt64(out, offsets.timestamp());
    }

    private static Offsets readMetadataOffsets(InputStream in) throws IOException {
        return new Offsets(RangeQueryResultSerialiser.checkNonNegative(EncodedDataCodec.readInt64(in), "offset sequence"), EncodedDataCodec.readInt64(in));
    }

    private static Map<String, byte[]> writeAuthorEncodings(OutputStream out, ImmutableSortedSet<String> repeatAuthors) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        byte[] code = new byte[]{};
        for (String s : repeatAuthors) {
            result.put(s, code);
            EncodedDataCodec.writeByte(out, (byte)3);
            EncodedDataCodec.writeByteArray(out, code);
            EncodedDataCodec.writeString(out, s);
            code = RangeQueryResultSerialiser.nextAuthorCode(code);
        }
        return result;
    }

    static byte[] nextAuthorCode(byte[] code) {
        byte[] result = Arrays.copyOf(code, code.length);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = (byte)(result[n] + 1);
            byte n2 = result[n];
            if (n2 == 0) continue;
            return result;
        }
        return new byte[result.length + 1];
    }

    private static void readAuthorEncoding(InputStream in, Map<IBytes, String> codeToAuthor) throws IOException {
        IBytes code = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        codeToAuthor.put(code, EncodedDataCodec.readString(in));
    }

    private static Minimums calculateMinimums(List<TimeSeries.Event<IBytes>> events) {
        return Streams.stream(events).reduce(Minimums.IDENTITY, Minimums::accumulateMinimums, (a, b) -> null);
    }

    @Immutable
    private static final class Minimums {
        private static final Minimums IDENTITY = new Minimums(Offsets.IDENTITY, ImmutableSortedSet.empty(), ImmutableSortedSet.empty());
        private final Offsets offsets;
        private final ImmutableSortedSet<String> authors;
        private final ImmutableSortedSet<String> repeatAuthors;

        Minimums(Offsets offsets, ImmutableSortedSet<String> authors, ImmutableSortedSet<String> repeatAuthors) {
            this.offsets = offsets;
            this.authors = authors;
            this.repeatAuthors = repeatAuthors;
        }

        Offsets offsets() {
            return this.offsets;
        }

        ImmutableSortedSet<String> repeatAuthors() {
            return this.repeatAuthors;
        }

        Minimums withAuthor(String author) {
            ImmutableSet newAuthors = this.authors.with((Object)author);
            if (newAuthors == this.authors) {
                ImmutableSet newRepeatAuthors = this.repeatAuthors.with((Object)author);
                if (newRepeatAuthors == this.repeatAuthors) {
                    return this;
                }
                return new Minimums(this.offsets, (ImmutableSortedSet<String>)newAuthors, (ImmutableSortedSet<String>)newRepeatAuthors);
            }
            return new Minimums(this.offsets, (ImmutableSortedSet<String>)newAuthors, this.repeatAuthors);
        }

        Minimums withOffsets(Offsets os) {
            if (os.equals(this.offsets)) {
                return this;
            }
            return new Minimums(os, this.authors, this.repeatAuthors);
        }

        Minimums accumulateMinimums(TimeSeries.Event<?> md) {
            return this.withOffsets(this.offsets.accumulateMinimums(md)).withAuthor(md.author()).withAuthor(md.originalEvent().author());
        }
    }

    @Immutable
    private static final class Offsets {
        private static final Offsets IDENTITY = new Offsets(Long.MAX_VALUE, Long.MAX_VALUE);
        private final long sequence;
        private final long timestamp;

        Offsets(long sequence, long timestamp) {
            this.sequence = sequence;
            this.timestamp = timestamp;
        }

        long sequence() {
            return this.sequence;
        }

        long timestamp() {
            return this.timestamp;
        }

        Offsets with(long s, long t) {
            if (s == this.sequence && t == this.timestamp) {
                return this;
            }
            return new Offsets(s, t);
        }

        Offsets accumulateMinimums(TimeSeries.Event<?> md) {
            TimeSeries.EventMetadata oe = md.originalEvent();
            return this.with(Math.min(this.sequence, Math.min(md.sequence(), oe.sequence())), Math.min(this.timestamp, Math.min(md.timestamp(), oe.timestamp())));
        }
    }
}

