/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.query;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryParameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="range-query-parameters", valueType=RangeQueryParameters.class)
public class RangeQueryParametersSerialiser
extends AbstractSerialiser<RangeQueryParameters> {
    private static final EnumConverter<RangeQueryParameters.QueryType> QUERY_TYPE_CONVERTER = new EnumConverter.Builder<RangeQueryParameters.QueryType>(RangeQueryParameters.QueryType.class).bimap(0, RangeQueryParameters.QueryType.VALUES).bimap(1, RangeQueryParameters.QueryType.ALL_EDITS).bimap(2, RangeQueryParameters.QueryType.LATEST_EDITS).build();
    private static final EnumConverter<RangeQueryParameters.Point.Type> POINT_TYPE_CONVERTER = new EnumConverter.Builder<RangeQueryParameters.Point.Type>(RangeQueryParameters.Point.Type.class).bimap(0, RangeQueryParameters.Point.Type.ABSOLUTE_START).bimap(1, RangeQueryParameters.Point.Type.ABSOLUTE_SEQUENCE).bimap(2, RangeQueryParameters.Point.Type.ABSOLUTE_TIME).bimap(3, RangeQueryParameters.Point.Type.OFFSET_SEQUENCE).bimap(4, RangeQueryParameters.Point.Type.OFFSET_TIME).bimap(5, RangeQueryParameters.Point.Type.NEXT_COUNT).bimap(6, RangeQueryParameters.Point.Type.NEXT_TIME).bimap(7, RangeQueryParameters.Point.Type.PREVIOUS_COUNT).bimap(8, RangeQueryParameters.Point.Type.PREVIOUS_TIME).build();

    @Override
    public void write(OutputStream out, RangeQueryParameters value) throws IOException {
        EncodedDataCodec.writeByte(out, QUERY_TYPE_CONVERTER.toByte(value.getQueryType()));
        RangeQueryParametersSerialiser.writeRange(out, value.getViewRange());
        RangeQueryParametersSerialiser.writeRange(out, value.getEditRange());
        EncodedDataCodec.writeInt64(out, value.getLimit());
    }

    @Override
    protected RangeQueryParameters readUnchecked(InputStream in) throws IOException {
        RangeQueryParameters.QueryType queryType = QUERY_TYPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        RangeQueryParameters.Range viewRange = RangeQueryParametersSerialiser.readRange(in);
        RangeQueryParameters.Range editRange = RangeQueryParametersSerialiser.readRange(in);
        long limit = EncodedDataCodec.readInt64(in);
        return new RangeQueryParameters(queryType, viewRange, editRange, limit);
    }

    private static void writeRange(OutputStream out, RangeQueryParameters.Range range) throws IOException {
        RangeQueryParametersSerialiser.writePoint(out, range.getAnchor());
        RangeQueryParametersSerialiser.writePoint(out, range.getSpan());
    }

    private static RangeQueryParameters.Range readRange(InputStream in) throws IOException {
        RangeQueryParameters.Point anchor = RangeQueryParametersSerialiser.readPoint(in);
        if (!anchor.isAbsolute()) {
            throw new IOException("Relative anchor point: " + String.valueOf(anchor));
        }
        RangeQueryParameters.Point span = RangeQueryParametersSerialiser.readPoint(in);
        return new RangeQueryParameters.Range(anchor, span);
    }

    private static void writePoint(OutputStream out, RangeQueryParameters.Point point) throws IOException {
        EncodedDataCodec.writeInt64(out, point.getValue());
        EncodedDataCodec.writeByte(out, POINT_TYPE_CONVERTER.toByte(point.getType()));
    }

    private static RangeQueryParameters.Point readPoint(InputStream in) throws IOException {
        long value = EncodedDataCodec.readInt64(in);
        RangeQueryParameters.Point.Type type = POINT_TYPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        if (!type.validate(value)) {
            throw new IOException("Invalid " + String.valueOf((Object)type) + " value: " + value);
        }
        return new RangeQueryParameters.Point(value, type);
    }
}

