/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.query;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.java7.Comparators;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.java7.Streams;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.Immutable;

@Immutable
final class QueryResultImpl<V>
implements TimeSeries.QueryResult<V> {
    private final long selectedCount;
    private final long eventCount;
    private final TimeSeries.QueryResult.StreamStructure streamStructure;
    private final Supplier<Stream<TimeSeries.Event<V>>> streamFactory;

    <T> QueryResultImpl(long selectedCount, TimeSeries.QueryResult.StreamStructure streamStructure, List<TimeSeries.Event<T>> events, Function<TimeSeries.Event<T>, TimeSeries.Event<V>> readValue) {
        this(selectedCount, events.size(), streamStructure, () -> Streams.stream(events).map(readValue));
    }

    private QueryResultImpl(long selectedCount, long eventCount, TimeSeries.QueryResult.StreamStructure streamStructure, Supplier<Stream<TimeSeries.Event<V>>> streamFactory) {
        this.selectedCount = selectedCount;
        this.eventCount = eventCount;
        this.streamStructure = streamStructure;
        this.streamFactory = streamFactory;
    }

    @Override
    public long selectedCount() {
        return this.selectedCount;
    }

    @Override
    public Stream<TimeSeries.Event<V>> stream() {
        return this.streamFactory.get();
    }

    @Override
    public boolean isComplete() {
        return this.selectedCount == this.eventCount;
    }

    @Override
    public TimeSeries.QueryResult.StreamStructure streamStructure() {
        return this.streamStructure;
    }

    @Override
    public TimeSeries.QueryResult<V> merge(TimeSeries.QueryResult<V> other) {
        List merged = Streams.concat(this.stream(), other.stream()).sorted(QueryResultImpl.comparingSequenceNumbers()).map(QueryResultImpl.replaceWithLatest(Streams.concat(this.stream(), other.stream()))).filter(Objects::nonNull).collect(Collectors.toList());
        int count = merged.size();
        return new QueryResultImpl<V>((long)count, count, TimeSeries.QueryResult.StreamStructure.VALUE_EVENT_STREAM, () -> Streams.stream(merged));
    }

    private static Comparator<TimeSeries.Event<?>> comparingSequenceNumbers() {
        return Comparators.thenComparing(Comparators.comparingLong(e -> e.originalEvent().sequence()), Comparators.comparingLong(TimeSeries.EventMetadata::sequence));
    }

    private static <V> Function<TimeSeries.Event<V>, TimeSeries.Event<V>> replaceWithLatest(Stream<TimeSeries.Event<V>> allEvents) {
        Map latestByOriginalSequence = allEvents.collect(Collectors.toMap(e -> e.originalEvent().sequence(), Functions.identity(), (first, second) -> first.sequence() > second.sequence() ? first : second));
        return e -> {
            Long originalSequence = new Long(e.originalEvent().sequence());
            TimeSeries.Event latest = (TimeSeries.Event)latestByOriginalSequence.get(originalSequence);
            if (latest == null) {
                return null;
            }
            if (!e.isEditEvent()) {
                latestByOriginalSequence.remove(originalSequence);
                return latest;
            }
            if (e.sequence() == latest.sequence()) {
                latestByOriginalSequence.remove(originalSequence);
                return e;
            }
            return null;
        };
    }

    public String toString() {
        return "QueryResult selected count=" + this.selectedCount + " event count=" + this.eventCount + " structure=" + String.valueOf((Object)this.streamStructure);
    }
}

