/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.statistics.ServerMetrics;
import com.pushtechnology.diffusion.utils.tuple.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@CommandSerialiser(spec="server-metrics", valueType=ServerMetrics.class)
public final class ServerMetricsSerialiser
extends AbstractSerialiser<ServerMetrics> {
    @Override
    public void write(OutputStream out, ServerMetrics value) throws IOException {
        List<Pair<String, List<String>>> entities = value.getEntities();
        int n = entities.size();
        EncodedDataCodec.writeInt32(out, n);
        for (int i = 0; i < n; ++i) {
            Pair<String, List<String>> entity = entities.get(i);
            List<String> names = entity.getSecond();
            int numberOfMetrics = names.size();
            long[] values = value.getValues().get(i);
            EncodedDataCodec.writeString(out, entity.getFirst());
            EncodedDataCodec.writeInt32(out, numberOfMetrics);
            for (int j = 0; j < numberOfMetrics; ++j) {
                EncodedDataCodec.writeString(out, names.get(j));
                EncodedDataCodec.writeInt64(out, values[j]);
            }
        }
    }

    @Override
    protected ServerMetrics readUnchecked(InputStream in) throws IOException {
        int n = EncodedDataCodec.readInt32(in);
        ArrayList<Pair<String, List<String>>> entities = new ArrayList<Pair<String, List<String>>>(n);
        ArrayList<long[]> values = new ArrayList<long[]>(n);
        for (int i = 0; i < n; ++i) {
            String entityClassName = EncodedDataCodec.readString(in);
            int numberOfMetrics = EncodedDataCodec.readInt32(in);
            ArrayList<String> metricNames = new ArrayList<String>(numberOfMetrics);
            long[] metricValues = new long[numberOfMetrics];
            for (int j = 0; j < numberOfMetrics; ++j) {
                metricNames.add(EncodedDataCodec.readString(in));
                metricValues[j] = EncodedDataCodec.readInt64(in);
            }
            entities.add(Pair.of(entityClassName, metricNames));
            values.add(metricValues);
        }
        return new ServerMetrics(entities, values);
    }
}

