/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.utils.tuple.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.jcip.annotations.Immutable;

@Immutable
public final class ServerMetrics {
    private static final Collector<CharSequence, ?, String> JOINING = Collectors.joining(", ", "[", "]");
    private final List<Pair<String, List<String>>> entities;
    private final List<long[]> values;

    public ServerMetrics(List<Pair<String, List<String>>> entities, List<long[]> values) {
        this.entities = entities;
        this.values = values;
    }

    List<Pair<String, List<String>>> getEntities() {
        return this.entities;
    }

    List<long[]> getValues() {
        return this.values;
    }

    public Map<String, Map<String, Long>> asMap() {
        return IntStream.range(0, this.entities.size()).mapToObj(i -> Pair.of(this.entities.get(i), i)).collect(Collectors.toMap(p -> (String)((Pair)p.getFirst()).getFirst(), p -> {
            List metricNames = (List)((Pair)p.getFirst()).getSecond();
            long[] vs = this.values.get((Integer)p.getSecond());
            return IntStream.range(0, metricNames.size()).boxed().collect(Collectors.toMap(metricNames::get, x -> vs[x]));
        }));
    }

    public int hashCode() {
        return this.entities.hashCode() + 31 * Arrays.deepHashCode(this.values.toArray());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerMetrics)) {
            return false;
        }
        ServerMetrics other = (ServerMetrics)o;
        return this.entities.equals(other.entities) && Arrays.deepEquals(this.values.toArray(), other.values.toArray());
    }

    public String toString() {
        return IntStream.range(0, this.entities.size()).mapToObj(i -> {
            Pair<String, List<String>> entity = this.entities.get(i);
            String entityClassName = entity.getFirst();
            List<String> metricNames = entity.getSecond();
            long[] vs = this.values.get(i);
            return entityClassName + IntStream.range(0, metricNames.size()).mapToObj(j -> (String)metricNames.get(j) + "=" + vs[j]).collect(JOINING);
        }).collect(JOINING);
    }
}

