/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
public final class SerializableMetricsRequest {
    private final Set<String> filters;
    private final Pattern patternFilter;
    private final String server;
    private final RequestType requestType;

    public SerializableMetricsRequest(Set<String> filters, Pattern patternFilter, String server, RequestType requestType) {
        this.filters = new HashSet<String>(filters);
        this.patternFilter = patternFilter;
        this.server = server;
        this.requestType = requestType;
    }

    public Set<String> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    public Pattern getPatternFilter() {
        return this.patternFilter;
    }

    public String getServer() {
        if (this.requestType != RequestType.NAMED_SERVER) {
            throw new IllegalStateException("Server is only available for named server requests");
        }
        return this.server;
    }

    public RequestType requestType() {
        return this.requestType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializableMetricsRequest that = (SerializableMetricsRequest)o;
        String thisPattern = this.patternFilter == null ? null : this.patternFilter.pattern();
        String thatPattern = that.patternFilter == null ? null : that.patternFilter.pattern();
        return Objects.equals(this.filters, that.filters) && Objects.equals(thisPattern, thatPattern) && Objects.equals(this.server, that.server) && this.requestType == that.requestType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filters, this.patternFilter, this.server, this.requestType});
    }

    public String toString() {
        return "MetricsRequest [filters=" + String.valueOf(this.filters) + ", patternFilter=" + String.valueOf(this.patternFilter) + ", server=" + this.server + ", currentServer=" + String.valueOf((Object)this.requestType) + "]";
    }

    public static enum RequestType {
        CURRENT_SERVER,
        ALL_SERVERS,
        NAMED_SERVER;

        private static final EnumConverter<RequestType> CONVERTER;

        static RequestType fromByte(byte b) {
            return CONVERTER.fromByte(b);
        }

        byte toByte() {
            return CONVERTER.toByte(this);
        }

        static {
            CONVERTER = new EnumConverter.Builder<RequestType>(RequestType.class).bimap(0, CURRENT_SERVER).bimap(1, ALL_SERVERS).bimap(2, NAMED_SERVER).build();
        }
    }
}

