/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.statistics.MetricSampleImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

@CommandSerialiser(spec="protocol26-metrics-sample", valueType=Metrics.MetricSample.class)
public final class Protocol26MetricSampleSerialiser
extends AbstractSerialiser<Metrics.MetricSample> {
    @Override
    public void write(OutputStream out, Metrics.MetricSample sample) throws IOException {
        EncodedDataCodec.writeDouble(out, sample.getValue());
        EncodedDataCodec.writeInt64(out, sample.getTimestamp().orElse(-1L));
        EncodedDataCodec.writeString(out, sample.getName());
        assert (sample.getLabelNames().size() == sample.getLabelValues().size());
        Protocol26MetricSampleSerialiser.writeStrings(out, sample.getLabelNames());
        Protocol26MetricSampleSerialiser.writeStrings(out, sample.getLabelValues());
    }

    @Override
    protected Metrics.MetricSample readUnchecked(InputStream in) throws IOException {
        double value = EncodedDataCodec.readDouble(in);
        long timestamp = EncodedDataCodec.readInt64(in);
        String name = EncodedDataCodec.readString(in);
        List<String> labelNames = Protocol26MetricSampleSerialiser.readStrings(in);
        List<String> labelValues = Protocol26MetricSampleSerialiser.readStrings(in);
        assert (labelNames.size() == labelValues.size());
        return new MetricSampleImpl(name, labelNames, labelValues, timestamp == -1L ? null : Long.valueOf(timestamp), value);
    }
}

