/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.servers;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.servers.AbstractRemoteServerSerialiser;
import com.pushtechnology.diffusion.servers.RemoteServerConnectionOptionConverter;
import com.pushtechnology.diffusion.servers.RemoteServerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

@CommandSerialiser(spec="protocol23-remote-server", valueType=RemoteServers.RemoteServer.class)
public final class Protocol23RemoteServerSerialiser
extends AbstractRemoteServerSerialiser {
    @Override
    public void write(OutputStream out, RemoteServers.RemoteServer server) throws IOException {
        RemoteServerImpl impl = (RemoteServerImpl)server;
        EncodedDataCodec.writeString(out, impl.getName());
        EncodedDataCodec.writeString(out, impl.getUrl());
        EncodedDataCodec.writeString(out, impl.getPrincipal());
        Protocol23RemoteServerSerialiser.writeMap(out, (o, v) -> EncodedDataCodec.writeByte(out, RemoteServerConnectionOptionConverter.toByte(v)), (o, v) -> EncodedDataCodec.writeString(out, v), impl.getConnectionOptions());
        String filter = impl.getMissingTopicNotificationFilter();
        if (filter == null) {
            EncodedDataCodec.writeString(out, "");
        } else {
            EncodedDataCodec.writeString(out, filter);
        }
    }

    @Override
    protected RemoteServers.RemoteServer readUnchecked(InputStream in) throws IOException {
        String name = EncodedDataCodec.readString(in);
        String url = EncodedDataCodec.readString(in);
        String principal = EncodedDataCodec.readString(in);
        Map<RemoteServers.RemoteServer.ConnectionOption, String> options = Protocol23RemoteServerSerialiser.readMap(in, i -> RemoteServerConnectionOptionConverter.fromByte(EncodedDataCodec.readByte(in)), i -> EncodedDataCodec.readString(in));
        String mtnFilter = EncodedDataCodec.readString(in);
        return RemoteServerImpl.createSecondary(RemoteServers.RemoteServer.Type.SECONDARY_INITIATOR, name, url, principal, options, mtnFilter.isEmpty() ? null : mtnFilter);
    }
}

