/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.servers;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.types.ErrorReport;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class CreateRemoteServerResult {
    private final RemoteServers.RemoteServer theRemoteServer;
    private final List<ErrorReport> theErrors;

    public static CreateRemoteServerResult success(RemoteServers.RemoteServer newServer) {
        return new CreateRemoteServerResult(newServer, Collections.emptyList());
    }

    public static CreateRemoteServerResult errors(List<ErrorReport> errors) {
        return new CreateRemoteServerResult(null, errors);
    }

    public CreateRemoteServerResult(RemoteServers.RemoteServer remoteServer, List<ErrorReport> errors) {
        this.theRemoteServer = remoteServer;
        this.theErrors = errors;
    }

    public boolean isSuccess() {
        return this.theErrors.isEmpty();
    }

    public RemoteServers.RemoteServer getRemoteServer() {
        return this.theRemoteServer;
    }

    public List<ErrorReport> getErrors() {
        return this.theErrors;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.theErrors.hashCode();
        result = 31 * result + (this.theRemoteServer == null ? 0 : this.theRemoteServer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateRemoteServerResult other = (CreateRemoteServerResult)obj;
        return this.theErrors.equals(other.theErrors) && Objects.equals(this.theRemoteServer, other.theRemoteServer);
    }

    public String toString() {
        return "CreateRemoteServerResult [" + String.valueOf(this.theRemoteServer) + ", Errors=" + String.valueOf(this.theErrors) + "]";
    }
}

