/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.common;

import com.pushtechnology.diffusion.client.features.control.clients.SystemAuthenticationControl;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class SystemPrincipalImpl
implements SystemAuthenticationControl.SystemPrincipal {
    private final String name;
    private final Set<String> roles;
    private final String lockingPrincipal;

    public SystemPrincipalImpl(String name, Set<String> roles) {
        this(name, roles, null);
    }

    public SystemPrincipalImpl(String name, Set<String> roles, String lockingPrincipal) {
        this.name = name;
        this.roles = ImmutableSet.from(roles);
        this.lockingPrincipal = lockingPrincipal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getAssignedRoles() {
        return this.roles;
    }

    @Override
    public Optional<String> getLockingPrincipal() {
        return Optional.ofNullable(this.lockingPrincipal);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.roles, this.lockingPrincipal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemPrincipalImpl other = (SystemPrincipalImpl)o;
        return this.name.equals(other.name) && this.roles.equals(other.roles) && Objects.equals(this.lockingPrincipal, other.lockingPrincipal);
    }

    public String toString() {
        return String.format("%s[name=%s, roles=%s, lockingPrincipal=%s]", this.getClass().getSimpleName(), this.name, this.roles, this.lockingPrincipal);
    }
}

