/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.common;

import com.pushtechnology.diffusion.client.features.control.clients.SystemAuthenticationControl;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.security.common.MatchesSessionPropertyValidationImpl;
import com.pushtechnology.diffusion.security.common.SessionPropertyValidationImpl;
import com.pushtechnology.diffusion.security.common.ValuesSessionPropertyValidationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="session-property-validation", valueType=SystemAuthenticationControl.SessionPropertyValidation.class)
public final class SessionPropertyValidationSerialiser
extends AbstractSerialiser<SystemAuthenticationControl.SessionPropertyValidation> {
    private static final EnumConverter<SessionPropertyValidationImpl.Type> TYPE_CONVERTER = new EnumConverter.Builder<SessionPropertyValidationImpl.Type>(SessionPropertyValidationImpl.Type.class).bimap(0, SessionPropertyValidationImpl.Type.REGEX).bimap(1, SessionPropertyValidationImpl.Type.VALUES).build();

    @Override
    protected SystemAuthenticationControl.SessionPropertyValidation readUnchecked(InputStream in) throws IOException {
        SessionPropertyValidationImpl.Type type = TYPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        if (type == SessionPropertyValidationImpl.Type.VALUES) {
            ImmutableSet<String> values = ImmutableSet.from(SessionPropertyValidationSerialiser.readStrings(in));
            return new ValuesSessionPropertyValidationImpl(values);
        }
        String regex = EncodedDataCodec.readString(in);
        return new MatchesSessionPropertyValidationImpl(regex);
    }

    @Override
    public void write(OutputStream out, SystemAuthenticationControl.SessionPropertyValidation value) throws IOException {
        SessionPropertyValidationImpl.Type type = ((SessionPropertyValidationImpl)value).getType();
        EncodedDataCodec.writeByte(out, TYPE_CONVERTER.toByte(type));
        if (type == SessionPropertyValidationImpl.Type.VALUES) {
            SystemAuthenticationControl.SessionPropertyValidation.ValuesSessionPropertyValidation value1 = (SystemAuthenticationControl.SessionPropertyValidation.ValuesSessionPropertyValidation)value;
            SessionPropertyValidationSerialiser.writeStrings(out, value1.getValues());
        } else {
            SystemAuthenticationControl.SessionPropertyValidation.MatchesSessionPropertyValidation value1 = (SystemAuthenticationControl.SessionPropertyValidation.MatchesSessionPropertyValidation)value;
            EncodedDataCodec.writeString(out, value1.getRegex());
        }
    }
}

