/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.common;

import com.pushtechnology.diffusion.client.features.control.clients.SecurityControl;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.collections.ImmutableSortedSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class SecurityConfigurationImpl
implements SecurityControl.SecurityConfiguration {
    private final Set<String> rolesForAnonymousSessions;
    private final Set<String> rolesForNamedSessions;
    private final List<SecurityControl.Role> roles;
    private final Set<String> isolatedPaths;

    public SecurityConfigurationImpl(Set<String> rolesForAnonymousSessions, Set<String> rolesForNamedSessions, List<SecurityControl.Role> roles, Set<String> isolatedPaths) {
        this.rolesForAnonymousSessions = ImmutableSet.from(rolesForAnonymousSessions);
        this.rolesForNamedSessions = ImmutableSortedSet.from(rolesForNamedSessions);
        this.roles = Collections.unmodifiableList(Objects.requireNonNull(roles));
        this.isolatedPaths = ImmutableSet.from(isolatedPaths);
    }

    @Override
    public Set<String> getRolesForAnonymousSessions() {
        return this.rolesForAnonymousSessions;
    }

    @Override
    public Set<String> getRolesForNamedSessions() {
        return this.rolesForNamedSessions;
    }

    @Override
    public List<SecurityControl.Role> getRoles() {
        return this.roles;
    }

    @Override
    public Set<String> getIsolatedPaths() {
        return this.isolatedPaths;
    }

    public int hashCode() {
        return Objects.hash(this.rolesForAnonymousSessions, this.rolesForNamedSessions, this.roles, this.isolatedPaths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityConfigurationImpl)) {
            return false;
        }
        SecurityConfigurationImpl other = (SecurityConfigurationImpl)o;
        return this.rolesForAnonymousSessions.equals(other.rolesForAnonymousSessions) && this.rolesForNamedSessions.equals(other.rolesForNamedSessions) && this.roles.equals(other.roles) && this.isolatedPaths.equals(other.isolatedPaths);
    }

    public String toString() {
        return "Roles for Anonymous Sessions=" + this.rolesForAnonymousSessions + ", Roles for Named Sessions=" + this.rolesForNamedSessions + ", Roles=" + this.roles + ", Isolated paths=" + this.isolatedPaths;
    }
}

