/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.proxy;

import com.pushtechnology.diffusion.client.session.proxy.HTTPProxyAuthentication;
import com.pushtechnology.diffusion.comms.connection.ConnectionException;
import com.pushtechnology.diffusion.comms.connection.ProxyConnector;
import com.pushtechnology.diffusion.http.HTTPHeaders;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.proxy.ProxyAuthenticationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;

@Immutable
public final class HTTPProxyNegotiator
implements ProxyConnector {
    private static final Logger LOG = I18nLogger.getLogger(HTTPProxyNegotiator.class);
    private static final Pattern PROXY_OK_RESPONSE = Pattern.compile("^HTTP/1.1 200|^HTTP/1.0 200");
    private static final Pattern PROXY_AUTH_RESPONSE = Pattern.compile("^HTTP/1.1 40(1|7)|^HTTP/1.0 40(1|7)");
    private final String proxyHost;
    private final int proxyPort;
    private final HTTPProxyAuthentication.ChallengeHandler challengeHandler;
    private final int socketTimeout;
    private final int sendBufferSize;
    private final int receiveBufferSize;
    private final SocketChannelFactory factory;

    public HTTPProxyNegotiator(String host, int port, HTTPProxyAuthentication.ChallengeHandler handler, int soTimeout, int outBufferSize, int inBufferSize) {
        this(host, port, handler, soTimeout, outBufferSize, inBufferSize, SocketChannel::open);
    }

    HTTPProxyNegotiator(String host, int port, HTTPProxyAuthentication.ChallengeHandler handler, int soTimeout, int outBufferSize, int inBufferSize, SocketChannelFactory sf) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.challengeHandler = handler;
        this.socketTimeout = soTimeout;
        this.sendBufferSize = outBufferSize;
        this.receiveBufferSize = inBufferSize;
        this.factory = sf;
    }

    private Socket connectToProxy() throws IOException {
        InetSocketAddress endpoint = new InetSocketAddress(this.proxyHost, this.proxyPort);
        SocketChannel socketChannel = this.factory.openSocketChannel();
        Socket socket = socketChannel.socket();
        socket.setSoTimeout(this.socketTimeout);
        socket.setSendBufferSize(this.sendBufferSize);
        socket.setReceiveBufferSize(this.receiveBufferSize);
        socket.setKeepAlive(true);
        socket.setTcpNoDelay(true);
        socket.connect(endpoint, this.socketTimeout);
        return socket;
    }

    @Override
    public SocketChannel sendConnectRequest(String host, int port) throws ConnectionException {
        try {
            return this.sendConnectRequest(host, port, null, 1, this.connectToProxy());
        }
        catch (ProxyAuthenticationException e) {
            LOG.warn("PROXY_UNABLE_TO_ESTABLISH_TUNNEL", this.proxyHost, this.proxyPort, e);
            throw e;
        }
        catch (IOException e) {
            LOG.warn("PROXY_UNABLE_TO_ESTABLISH_TUNNEL", this.proxyHost, this.proxyPort, e);
            throw new ConnectionException("Unable to establish tunnel through proxy", e);
        }
    }

    private SocketChannel sendConnectRequest(String host, int port, Map<String, String> headers, int depth, Socket socket) throws IOException {
        StringBuilder builder = new StringBuilder();
        String initialHeaders = "CONNECT " + host + ":" + port + " HTTP/1.1\r\nUser-Agent: Diffusion\r\nHost: " + host + ":" + port + "\r\nContent-Length: 0\r\nProxy-Connection: Keep-Alive\r\nPragma: no-cache\r\n";
        builder.append(initialHeaders);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.append(entry.getKey() + ": " + entry.getValue() + "\r\n");
            }
        }
        builder.append("\r\n");
        String msg = builder.toString();
        OutputStream out = socket.getOutputStream();
        byte[] b = msg.getBytes(StandardCharsets.ISO_8859_1);
        out.write(b);
        out.flush();
        HTTPHeaders response = HTTPProxyNegotiator.getResponse(socket);
        Matcher okMatcher = PROXY_OK_RESPONSE.matcher(response.getFirstLine());
        if (okMatcher.find()) {
            return socket.getChannel();
        }
        if (depth >= this.challengeHandler.getMaximumConversations()) {
            throw new ProxyAuthenticationException("Unable to authenticate with proxy.");
        }
        if (PROXY_AUTH_RESPONSE.matcher(response.getFirstLine()).find()) {
            HashMap<String, String> challengeHeaders = new HashMap<String, String>(response.getNumberOfHeaders());
            response.forEach(challengeHeaders::put);
            Map<String, String> challengeResponse = this.challengeHandler.getResponse(challengeHeaders);
            return this.sendConnectRequest(host, port, challengeResponse, depth + 1, this.reconnectIfClosed(socket, response));
        }
        LOG.warn("PROXY_UNABLE_TO_ESTABLISH_TUNNEL", (Object)this.proxyHost, (Object)this.proxyPort);
        throw new ProxyAuthenticationException("Proxy Authentication required and not found.");
    }

    private Socket reconnectIfClosed(Socket socket, HTTPHeaders headers) throws IOException {
        String connectHeader = headers.find("Connection");
        if (socket.isConnected() && (connectHeader == null || "Keep-Alive".equalsIgnoreCase(connectHeader))) {
            HTTPProxyNegotiator.skipContentBytes(socket, headers);
            return socket;
        }
        socket.close();
        return this.connectToProxy();
    }

    private static void skipContentBytes(Socket socket, HTTPHeaders headers) throws ProxyAuthenticationException {
        String contentLength = headers.find("Content-Length");
        if (contentLength != null) {
            try {
                InputStream in = socket.getInputStream();
                long bytesToSkip = Integer.parseInt(contentLength);
                while ((bytesToSkip -= in.skip(bytesToSkip)) > 0L) {
                }
            }
            catch (IOException | NumberFormatException e) {
                throw new ProxyAuthenticationException("Error while skipping html content from proxy response.");
            }
        }
    }

    private static HTTPHeaders getResponse(Socket socket) throws IOException {
        InputStream in = socket.getInputStream();
        IBytesOutputStreamImpl ibos = IBytesOutputStreamImpl.forThread();
        int newLines = 0;
        while (newLines < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from Proxy");
            }
            ((IBytesOutputStream)ibos).write(i);
            if (i == 10) {
                ++newLines;
                continue;
            }
            if (i == 13) continue;
            newLines = 0;
        }
        ByteBuffer bb = ByteBuffer.allocate(((IBytesOutputStream)ibos).length());
        ((IBytesOutputStream)ibos).copyTo(bb);
        bb.flip();
        return HTTPHeaders.parseBuffer(bb);
    }

    static interface SocketChannelFactory {
        public SocketChannel openSocketChannel() throws IOException;
    }
}

