/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer.messageclient;

import com.pushtechnology.diffusion.flowcontrol.FlowMeasurement;
import com.pushtechnology.diffusion.flowcontrol.PendingOperations;
import com.pushtechnology.diffusion.flowcontrol.PressureCalculator;
import com.pushtechnology.diffusion.messagequeue.OutboundMessageQueueNumbers;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MultiplexerFlowMeasurement
implements FlowMeasurement {
    private final OutboundMessageQueueNumbers messageQueue;
    private final PendingOperations pendingOperations;

    public MultiplexerFlowMeasurement(OutboundMessageQueueNumbers messageQueue, PendingOperations pendingOperations) {
        this.messageQueue = messageQueue;
        this.pendingOperations = pendingOperations;
    }

    @Override
    public double toPressure(PressureCalculator calculator) {
        return calculator.toPressure(this.messageQueue.size() + this.pendingOperations.getCount(), this.messageQueue.getMaximumSize());
    }

    public String toString() {
        return String.format("%s, pending=%d, queue=%d, queue peak=%d, max=%d", this.messageQueue, this.pendingOperations.getCount(), this.messageQueue.size(), this.messageQueue.getLargestSize(), this.messageQueue.getMaximumSize());
    }
}

