/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer.impl;

import com.pushtechnology.diffusion.multiplexer.impl.CacheLinePadding;
import com.pushtechnology.diffusion.multiplexer.impl.MultiplexerReporter;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import com.pushtechnology.diffusion.time.SystemTime;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class MultiplexerRecorder
extends CacheLinePadding {
    private final MultiplexerReporter reporter;
    private final long threshold;
    private final long reportSuppressionPeriod;
    private int events;
    private long eventsLatency;
    private int clients;
    private long clientsLatency;
    private long lastTime = 0L;
    private long lastReport = Long.MIN_VALUE;
    private volatile long cycle;
    private static final AtomicLongFieldUpdater<MultiplexerRecorder> CYCLE = AtomicLongFieldUpdater.newUpdater(MultiplexerRecorder.class, "cycle");
    private volatile long eventsProcessed;
    private static final AtomicLongFieldUpdater<MultiplexerRecorder> EVENTS_PROCESSED = AtomicLongFieldUpdater.newUpdater(MultiplexerRecorder.class, "eventsProcessed");
    private volatile long clientsProcessed;
    private static final AtomicLongFieldUpdater<MultiplexerRecorder> CLIENTS_PROCESSED = AtomicLongFieldUpdater.newUpdater(MultiplexerRecorder.class, "clientsProcessed");
    private volatile long idleCycles;
    private static final AtomicLongFieldUpdater<MultiplexerRecorder> IDLE_CYCLES = AtomicLongFieldUpdater.newUpdater(MultiplexerRecorder.class, "idleCycles");

    public MultiplexerRecorder(MultiplexerReporter reporter, long threshold) {
        this(reporter, threshold, 5000L);
    }

    public MultiplexerRecorder(MultiplexerReporter reporter, long threshold, long reportSuppressionPeriod) {
        this.reporter = reporter;
        this.threshold = threshold;
        this.reportSuppressionPeriod = reportSuppressionPeriod;
    }

    @MultiplexerOnly
    private long lpCycle() {
        return CYCLE.get(this);
    }

    @MultiplexerOnly
    private void soCycle(long c) {
        CYCLE.lazySet(this, c);
    }

    private void lazyAdd(AtomicLongFieldUpdater<MultiplexerRecorder> updater, long delta) {
        updater.lazySet(this, updater.get(this) + delta);
    }

    @MultiplexerOnly
    public void startCycle() {
        this.soCycle(this.lpCycle() + 1L);
        this.events = 0;
        this.eventsLatency = 0L;
        this.clients = 0;
        this.clientsLatency = 0L;
    }

    @MultiplexerOnly
    public void updateTime() {
        this.lastTime = SystemTime.currentTimeMillis();
    }

    @MultiplexerOnly
    public long eventsProcessed(int count) {
        if (count > 0) {
            this.eventsLatency = this.time();
            this.events = count;
            this.lazyAdd(EVENTS_PROCESSED, count);
        }
        return this.eventsLatency;
    }

    @MultiplexerOnly
    public void clientsProcessed(int count) {
        this.clientsLatency += this.time();
        this.clients += count;
        this.lazyAdd(CLIENTS_PROCESSED, count);
    }

    @MultiplexerOnly
    private long time() {
        long now = SystemTime.currentTimeMillis();
        long result = now - this.lastTime;
        this.lastTime = now;
        return result;
    }

    @MultiplexerOnly
    public void endCycle(boolean idle) {
        if (idle) {
            this.lazyAdd(IDLE_CYCLES, 1L);
        }
        if (this.eventsLatency + this.clientsLatency >= this.threshold && this.lastTime >= this.lastReport + this.reportSuppressionPeriod) {
            this.lastReport = this.lastTime;
            this.reporter.reportSlowCycle(this.lpCycle(), this.events, this.eventsLatency, this.clients, this.clientsLatency);
        }
    }

    @MultiplexerOnly
    public long getLastTime() {
        return this.lastTime;
    }

    public long getCycle() {
        return this.cycle;
    }

    public long getEventsProcessed() {
        return this.eventsProcessed;
    }

    public long getClientsProcessed() {
        return this.clientsProcessed;
    }

    public long getIdleCycles() {
        return this.idleCycles;
    }
}

