/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer.impl;

import com.pushtechnology.diffusion.exceptions.DiffusionRuntimeException;
import com.pushtechnology.diffusion.multiplexer.impl.CacheLinePadding;
import java.util.ArrayDeque;
import java.util.Deque;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class IntegerPool
extends CacheLinePadding {
    private final int maximum;
    private final Deque<Integer> recycled = new ArrayDeque<Integer>();
    private int peak = -1;

    IntegerPool(int maximum) {
        this.maximum = maximum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getPeak() {
        return this.peak;
    }

    public int allocate() throws PoolExhaustedException {
        Integer r = this.recycled.poll();
        if (r != null) {
            return r;
        }
        if (this.peak >= this.maximum) {
            throw new PoolExhaustedException(this.maximum + " values allocated");
        }
        return ++this.peak;
    }

    public void recycle(int returned) {
        this.recycled.push(returned);
    }

    public static final class PoolExhaustedException
    extends DiffusionRuntimeException {
        private static final long serialVersionUID = 6146619916915400680L;

        private PoolExhaustedException(String message) {
            super(message);
        }
    }
}

