/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.metrics.alerts;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.metrics.alerts.InternalMetricAlert;
import com.pushtechnology.diffusion.metrics.alerts.MetricAlertImpl;
import com.pushtechnology.diffusion.security.authorisation.model.AuthenticatedPrincipal;
import com.pushtechnology.diffusion.security.authorisation.model.AuthenticatedPrincipalSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@CommandSerialiser(spec="protocol29-metric-alert", valueType=InternalMetricAlert.class)
public final class Protocol29MetricAlertSerialiser
extends AbstractSerialiser<InternalMetricAlert> {
    private final AuthenticatedPrincipalSerialiser authenticatedPrincipalSerialiser = new AuthenticatedPrincipalSerialiser();

    @Override
    public void write(OutputStream out, InternalMetricAlert value) throws IOException {
        EncodedDataCodec.writeString(out, value.getName());
        EncodedDataCodec.writeString(out, value.getSpecification());
        this.authenticatedPrincipalSerialiser.write(out, value.getAuthenticatedPrincipal());
    }

    @Override
    protected InternalMetricAlert readUnchecked(InputStream in) throws IOException {
        String name = EncodedDataCodec.readString(in);
        String specification = EncodedDataCodec.readString(in);
        AuthenticatedPrincipal authenticatedPrincipal = (AuthenticatedPrincipal)this.authenticatedPrincipalSerialiser.read(in);
        return new MetricAlertImpl(name, specification, authenticatedPrincipal);
    }
}

