/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.messagequeue;

import com.pushtechnology.diffusion.java7.Java7;
import net.jcip.annotations.Immutable;

@Immutable
public final class OutboundQueueConfiguration {
    public static final OutboundQueueConfiguration DEFAULT_QUEUE_CONFIGURATION = new OutboundQueueConfiguration(false, Long.MAX_VALUE, Long.MAX_VALUE, 1000, -1, -1);
    private final boolean conflationEnabled;
    private final long maximumQueuedBytes;
    private final long maximumConnectorBytes;
    private final int maximumQueueSize;
    private final int lowerThreshold;
    private final int upperThreshold;
    private final int messagesLowerThreshold;
    private final int messagesUpperThreshold;

    OutboundQueueConfiguration(boolean conflationEnabled, long maximumQueuedBytes, long maximumConnectorBytes, int maximumQueueSize, int lowerThreshold, int upperThreshold) {
        OutboundQueueConfiguration.validateThresholds(lowerThreshold, upperThreshold);
        this.conflationEnabled = conflationEnabled;
        this.maximumQueuedBytes = OutboundQueueConfiguration.requireAtLeast(maximumQueuedBytes, 0L, "maximumQueuedBytes");
        this.maximumConnectorBytes = OutboundQueueConfiguration.requireAtLeast(maximumConnectorBytes, 0L, "maximumConnectorBytes");
        this.maximumQueueSize = OutboundQueueConfiguration.requireAtLeast(maximumQueueSize, 1, "maximumQueueSize");
        this.lowerThreshold = lowerThreshold;
        this.upperThreshold = upperThreshold;
        this.messagesLowerThreshold = lowerThreshold == -1 ? -1 : maximumQueueSize * lowerThreshold / 100;
        this.messagesUpperThreshold = upperThreshold == -1 ? -1 : Math.max(maximumQueueSize * upperThreshold / 100, 1);
    }

    private static void validateThresholds(int lowerThreshold, int upperThreshold) {
        if (lowerThreshold < -1 || lowerThreshold > 99) {
            throw new IllegalArgumentException("Lower queue threshold " + lowerThreshold + " invalid");
        }
        if (upperThreshold != -1) {
            if (upperThreshold < 1 || upperThreshold > 100) {
                throw new IllegalArgumentException("Upper queue threshold " + upperThreshold + " invalid");
            }
            if (lowerThreshold >= upperThreshold) {
                throw new IllegalArgumentException("Lower queue threshold must be less than upper threshold");
            }
        }
    }

    private static int requireAtLeast(int value, int minimum, String name) {
        if (value < minimum) {
            throw new IllegalArgumentException(name + " must be at least " + minimum);
        }
        return value;
    }

    private static long requireAtLeast(long value, long minimum, String name) {
        if (value < minimum) {
            throw new IllegalArgumentException(name + " must be at least " + minimum);
        }
        return value;
    }

    public boolean isConflationEnabled() {
        return this.conflationEnabled;
    }

    public int getMaximumQueueSize() {
        return this.maximumQueueSize;
    }

    public long getMaximumQueuedBytes() {
        return this.maximumQueuedBytes;
    }

    public long getMaximumConnectorBytes() {
        return this.maximumConnectorBytes;
    }

    public int getLowerThreshold() {
        return this.lowerThreshold;
    }

    public int getMessagesLowerThreshold() {
        return this.messagesLowerThreshold;
    }

    public int getMessagesUpperThreshold() {
        return this.messagesUpperThreshold;
    }

    public int getUpperThreshold() {
        return this.upperThreshold;
    }

    public OutboundQueueConfiguration withMaximumQueueSize(int newSize) {
        return new OutboundQueueConfiguration(this.conflationEnabled, this.maximumQueuedBytes, this.maximumConnectorBytes, newSize, this.lowerThreshold, this.upperThreshold);
    }

    public OutboundQueueConfiguration withMaximumConnectorBytes(long newBytes) {
        return new OutboundQueueConfiguration(this.conflationEnabled, this.maximumQueuedBytes, newBytes, this.maximumQueueSize, this.lowerThreshold, this.upperThreshold);
    }

    public OutboundQueueConfiguration withMaximumQueuedBytes(long newBytes) {
        return new OutboundQueueConfiguration(this.conflationEnabled, newBytes, this.maximumConnectorBytes, this.maximumQueueSize, this.lowerThreshold, this.upperThreshold);
    }

    public OutboundQueueConfiguration withConflation(boolean conflate) {
        return new OutboundQueueConfiguration(conflate, this.maximumQueuedBytes, this.maximumConnectorBytes, this.maximumQueueSize, this.lowerThreshold, this.upperThreshold);
    }

    public OutboundQueueConfiguration withThresholds(int lower, int upper) {
        return new OutboundQueueConfiguration(this.conflationEnabled, this.maximumQueuedBytes, this.maximumConnectorBytes, this.maximumQueueSize, lower, upper);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conflationEnabled ? 1231 : 1237);
        result = 31 * result + Java7.longHashCode(this.maximumConnectorBytes);
        result = 31 * result + Java7.longHashCode(this.maximumQueuedBytes);
        result = 31 * result + this.maximumQueueSize;
        result = 31 * result + this.lowerThreshold;
        result = 31 * result + this.upperThreshold;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutboundQueueConfiguration other = (OutboundQueueConfiguration)o;
        return this.conflationEnabled == other.conflationEnabled && this.lowerThreshold == other.lowerThreshold && this.upperThreshold == other.upperThreshold && this.maximumQueueSize == other.maximumQueueSize && this.maximumConnectorBytes == other.maximumConnectorBytes && this.maximumQueuedBytes == other.maximumQueuedBytes;
    }

    public String toString() {
        return String.format("size=%d conflation=%b thresholds=[%d, %d]", this.maximumQueueSize, this.conflationEnabled, this.lowerThreshold, this.upperThreshold);
    }
}

