/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.messagequeue;

import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.messagequeue.OutboundMessageQueue;
import com.pushtechnology.diffusion.messagequeue.OutboundQueueConfiguration;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import com.pushtechnology.diffusion.utils.unsafe.UnsafeAccess;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;

@MultiplexerOnly
public class OutboundMessageQueueImpl
implements OutboundMessageQueue {
    private static final Logger LOG = I18nLogger.getLogger(OutboundMessageQueueImpl.class);
    private static final boolean IS_TRACE_LOGGING = LOG.isTraceEnabled();
    private final Queue<Message> messageQueue;
    @MultiplexerOnly
    private OutboundQueueConfiguration configuration;
    private volatile int queueSize;
    private static final long QUEUE_SIZE_OFFSET;
    private volatile int largestQueueSize = 0;
    private static final AtomicIntegerFieldUpdater<OutboundMessageQueueImpl> LARGEST_QUEUE_SIZE_UPDATER;
    private volatile int sequence = 0;
    private static final AtomicIntegerFieldUpdater<OutboundMessageQueueImpl> SEQUENCE_UPDATER;
    private volatile int maximumQueueSize = 0;
    @MultiplexerOnly
    private long bytesQueued;

    public OutboundMessageQueueImpl(OutboundQueueConfiguration configuration, Queue<Message> messageQueue) {
        this.messageQueue = messageQueue;
        this.reconfigure(configuration);
    }

    @Override
    public final int size() {
        return this.queueSize;
    }

    @Override
    public final int getLargestSize() {
        return this.largestQueueSize;
    }

    @Override
    public final int getMaximumSize() {
        return this.maximumQueueSize;
    }

    @Override
    public final int getSequence() {
        return this.sequence;
    }

    @Override
    public final void setSequence(int s) {
        SEQUENCE_UPDATER.lazySet(this, s);
    }

    @Override
    public final void addToSequence(int numberOfMessages) {
        this.setSequence(this.sequence + numberOfMessages);
    }

    @Override
    public final void reconfigure(OutboundQueueConfiguration newConfiguration) {
        this.configuration = newConfiguration;
        this.maximumQueueSize = newConfiguration.getMaximumQueueSize();
    }

    @Override
    public final OutboundQueueConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final boolean hasCapacityFor(Message message) {
        OutboundQueueConfiguration c = this.configuration;
        return this.lpQueueSize() < c.getMaximumQueueSize() && this.hasCapacityForBytes(c, message.bodySize());
    }

    protected boolean hasCapacityForBytes(OutboundQueueConfiguration c, long deltaBytes) {
        return this.bytesQueued + deltaBytes <= c.getMaximumQueuedBytes();
    }

    @Override
    public final boolean hasAvailableMessages() {
        return this.lpQueueSize() != 0;
    }

    @Override
    public void clear() {
        this.messageQueue.clear();
        this.soCurrentSize(0);
        this.bytesQueued = 0L;
    }

    @Override
    public final Iterator<Message> iterator() {
        return this.messageQueue.iterator();
    }

    @Override
    public final Message poll() {
        int oldSize = this.lpQueueSize();
        if (oldSize == 0) {
            return null;
        }
        Message message = this.messageQueue.poll();
        this.queueIsSmaller(oldSize - 1, message, message.bodySize());
        return message;
    }

    protected void queueIsSmaller(int newSize, Message message, int messageSize) {
        this.soCurrentSize(newSize);
        this.bytesQueued -= (long)messageSize;
    }

    @Override
    public final Message peek() {
        return this.messageQueue.peek();
    }

    private void trace(String what, Message message) {
        if (IS_TRACE_LOGGING && LOG.isTraceEnabled()) {
            LOG.trace("{} {}: {} ({})", this, this.lpQueueSize(), what, message);
        }
    }

    @Override
    public final OutboundMessageQueue.QueueResult queue(Message message) {
        this.messageQueue.add(message);
        this.trace("queued", message);
        OutboundQueueConfiguration c = this.configuration;
        int newSize = this.lpQueueSize() + 1;
        int reportedSize = message.bodySize();
        OutboundMessageQueue.QueueResult result = (long)reportedSize > Math.min(c.getMaximumQueuedBytes(), c.getMaximumConnectorBytes()) ? OutboundMessageQueue.QueueResult.MESSAGE_TOO_LARGE : (newSize > c.getMaximumQueueSize() || !this.hasCapacityForBytes(c, reportedSize) ? OutboundMessageQueue.QueueResult.QUEUE_FULL : OutboundMessageQueue.QueueResult.ACCEPTED);
        this.queueIsLarger(newSize, message, reportedSize);
        return result;
    }

    protected void queueIsLarger(int newQueueSize, Message message, int messageSize) {
        this.setSize(newQueueSize, messageSize);
    }

    protected final void setSize(int totalMessages, long deltaBytes) {
        this.bytesQueued += deltaBytes;
        this.soCurrentSize(totalMessages);
        if (this.largestQueueSize < totalMessages) {
            this.soLargestSize(totalMessages);
        }
    }

    protected final int lpQueueSize() {
        return UnsafeAccess.UNSAFE.getInt(this, QUEUE_SIZE_OFFSET);
    }

    private void soCurrentSize(int newSize) {
        UnsafeAccess.UNSAFE.putOrderedInt(this, QUEUE_SIZE_OFFSET, newSize);
    }

    private void soLargestSize(int newSize) {
        LARGEST_QUEUE_SIZE_UPDATER.lazySet(this, newSize);
    }

    @Override
    public String describeOverflow() {
        String type = this.queueSize >= this.maximumQueueSize ? "outbound message" : "outbound byte";
        return type;
    }

    @Override
    public String createSummary() {
        return new StringBuilder(240).append(this).append(" size=").append(this.queueSize).append(" peak=").append(this.largestQueueSize).append(" maxSize=").append(this.maximumQueueSize).append(" sequence=").append(this.sequence).append(" bytesQueued=").append(this.bytesQueued).append(" maxBytesQueued=").append(this.configuration.getMaximumQueuedBytes()).toString();
    }

    @Override
    public final long bytesQueued() {
        return this.bytesQueued;
    }

    @Override
    public boolean canDelaySend() {
        return false;
    }

    protected final Queue<Message> getMessageQueue() {
        return this.messageQueue;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "/" + this.messageQueue.getClass().getSimpleName();
    }

    static {
        try {
            QUEUE_SIZE_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(OutboundMessageQueueImpl.class.getDeclaredField("queueSize"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        LARGEST_QUEUE_SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OutboundMessageQueueImpl.class, "largestQueueSize");
        SEQUENCE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OutboundMessageQueueImpl.class, "sequence");
    }
}

