/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.messagechannel;

import com.pushtechnology.diffusion.comms.connection.ConnectionInfo;
import com.pushtechnology.diffusion.comms.websocket.MaxMessageSizeException;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.ReadChannelHandler;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.message.MessageChannelClosedReason;
import com.pushtechnology.diffusion.message.MessageChannelListener;
import com.pushtechnology.diffusion.messagechannel.MessageChannelImpl;
import com.pushtechnology.diffusion.messagechannel.MessageChannelMultiplexerClient;
import com.pushtechnology.diffusion.threads.InboundThreadOnly;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;

public abstract class ReadChannelHandlerMessageChannel
extends MessageChannelImpl
implements ReadChannelHandler {
    private static final Logger LOG = I18nLogger.getLogger(ReadChannelHandlerMessageChannel.class);
    private final NetworkChannel channel;

    protected ReadChannelHandlerMessageChannel(NetworkChannel channel, ConnectionInfo connectionInfo, int outputBufferSize, MessageChannelMultiplexerClient multiplexerClient, MessageChannelListener listener) {
        super(connectionInfo, outputBufferSize, multiplexerClient, listener);
        this.channel = channel;
    }

    @Override
    public final NetworkChannel getChannel() {
        return this.channel;
    }

    @Override
    public final Object inboundThreadAffinityKey() {
        return this.getListener().inboundThreadAffinityKey();
    }

    @Override
    @InboundThreadOnly
    public final void handleEOF() {
    }

    @Override
    protected final void writeBufferComplete() {
        this.setReadyToSend();
    }

    @Override
    public final void closeTask() {
        this.closeInbound(this.channel, () -> this.onCloseCompleted(MessageChannelClosedReason.CONNECTION_LOST));
    }

    @Override
    public final void closeTaskOnError(IOException cause) {
        if (cause instanceof MaxMessageSizeException) {
            this.close(MessageChannelClosedReason.MESSAGE_TOO_LARGE, cause);
        } else {
            this.close(MessageChannelClosedReason.READ_ERROR, cause);
        }
    }

    @Override
    public final boolean isConnectionHandler() {
        return false;
    }

    protected final void logReceived(MessageChannelListener listener, int messageCount, int billedMessageCount, int bytesReceived, ByteBuffer buffer) {
        listener.updateInboundStatistics(messageCount, billedMessageCount, bytesReceived);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} processed {} messages in {} bytes from {}", this, messageCount, bytesReceived, buffer);
        }
    }
}

