/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.message;

import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageLogger {
    private static final Logger LOG = LoggerFactory.getLogger(MessageLogger.class);
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    private static final FastThreadLocal<StringBuilder> STRING_BUILDER_THREAD_LOCAL = FastThreadLocal.withInitial(() -> new StringBuilder(1024));

    private MessageLogger() {
    }

    public static void appendMessage(Message message) {
        if (LOG.isDebugEnabled()) {
            STRING_BUILDER_THREAD_LOCAL.get().append('\n').append(message.toString());
        }
    }

    public static void logMessages(Object context, int numberOfMessages) {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = STRING_BUILDER_THREAD_LOCAL.get();
            LOG.debug("{} writing {}: {}", context, numberOfMessages, sb);
            if (sb.capacity() > 0x100000) {
                STRING_BUILDER_THREAD_LOCAL.remove();
            } else {
                sb.setLength(0);
            }
        }
    }
}

