/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.message;

import com.pushtechnology.diffusion.comms.connection.ConnectionInfo;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.math.DiffusionMath;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public interface Message {
    public static final int BILLING_MESSAGE_BIT_SHIFT = -1 + DiffusionMath.highestBit(ConfigurationUtils.getIntegerSystemProperty("diffusion.billing_message_divisor", Integer.MIN_VALUE));

    public int bodySize();

    public int size(ConnectionInfo var1);

    public void write(ByteBuffer var1, ConnectionInfo var2) throws BufferOverflowException;

    public void writeWithPollingHeader(OutputStream var1, ConnectionInfo var2) throws IOException;

    default public int billedCost() {
        return Message.billedCostCalculation(this.bodySize());
    }

    public static int billedCostCalculation(int bodySize) {
        return 1 + (bodySize >> BILLING_MESSAGE_BIT_SHIFT);
    }
}

