/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.logs.i18n;

import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.util.Arrays;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
final class SuppressionTracker {
    private static final int THRESHOLD = ConfigurationUtils.getIntegerSystemProperty("diffusion.log_suppression.threshold", 3);
    private static final String SUPPRESSED_CODES_PROPERTY_NAME = "diffusion.log_suppression.codes";
    private static final String[] SUPPRESSED;
    private static final Logger LOG;
    private static final FastThreadLocal<SuppressionTracker> THREAD_LOCAL;
    private String lastCode = null;
    private int logCount = 0;

    SuppressionTracker() {
    }

    public static SuppressionTracker forThread() {
        return THREAD_LOCAL.get();
    }

    public boolean isSuppressed(String code) {
        if (code.equals(this.lastCode)) {
            return Arrays.binarySearch(SUPPRESSED, code) >= 0 && ++this.logCount > THRESHOLD;
        }
        int previousLogCount = this.logCount;
        this.logCount = 1;
        if (previousLogCount > THRESHOLD && LOG.isWarnEnabled()) {
            LOG.warn("LOG_SUPPRESSION", (Object)(previousLogCount - THRESHOLD), (Object)this.lastCode);
        }
        this.lastCode = code;
        return false;
    }

    static {
        String suppressed = ConfigurationUtils.getSystemProperty(SUPPRESSED_CODES_PROPERTY_NAME, "PUSH-000056,PUSH-000191,PUSH-000581,PUSH-000592,PUSH-000736,PUSH-000798,PUSH-000847,TEST005");
        SUPPRESSED = suppressed.split("[, ]+");
        Arrays.sort(SUPPRESSED);
        LOG = I18nLogger.getLogger(SuppressionTracker.class);
        THREAD_LOCAL = FastThreadLocal.withInitial(SuppressionTracker::new);
    }
}

