/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.logs.i18n;

import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

@ThreadSafe
public final class I18nUtils {
    public static final String DIFFUSION_RESOURCES = I18nUtils.class.getPackage().getName() + ".messages";
    public static final String ID_SUFFIX = ".ID";

    private I18nUtils() {
    }

    public static I18nLogger.Translation formatMessage(String key, Object ... messageArguments) {
        I18nLogger.Translation translation = I18nLogger.translate(key);
        if (messageArguments.length == 0) {
            return translation;
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(translation.getText(), messageArguments);
        if (tuple.getThrowable() != null) {
            throw new IllegalArgumentException("Trailing throwable not supported");
        }
        return translation.withText(tuple.getMessage());
    }
}

