/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.logs.i18n;

import com.pushtechnology.diffusion.logs.i18n.I18nUtils;
import com.pushtechnology.diffusion.logs.i18n.LogCounter;
import com.pushtechnology.diffusion.logs.i18n.SuppressionTracker;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ThreadSafe
@SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
public final class I18nLogger
implements Logger {
    private static final Marker NO_CODE_MARKER = MarkerFactory.getMarker("");
    private static final Marker TBD_MARKER = MarkerFactory.getMarker("TBD");
    @GuardedBy(value="Writes guarded by CACHE")
    private static final Map<String, Translation> CACHE = new ConcurrentHashMap<String, Translation>();
    private static final LogCounter NULL_LOG_COUNTER = new LogCounter(){

        @Override
        public void incrementTrace() {
        }

        @Override
        public void incrementDebug() {
        }

        @Override
        public void incrementInfo() {
        }

        @Override
        public void incrementWarn() {
        }

        @Override
        public void incrementError() {
        }
    };
    private static final Function<String, LogCounter> NULL_LOG_COUNTER_FACTORY = x -> NULL_LOG_COUNTER;
    private static volatile Function<String, LogCounter> logCounterFactory = NULL_LOG_COUNTER_FACTORY;
    private final Logger delegate;

    public static I18nLogger getLogger(Class<?> clazz) {
        Logger delegate = LoggerFactory.getLogger(clazz);
        return I18nLogger.getLogger(delegate);
    }

    public static I18nLogger getLogger(Logger delegate) {
        return new I18nLogger(delegate);
    }

    I18nLogger(Logger delegate) {
        this.delegate = delegate;
    }

    private static Translation getTranslation(String key) {
        ResourceBundle bundle = ResourceBundle.getBundle(I18nUtils.DIFFUSION_RESOURCES);
        if (!bundle.containsKey(key)) {
            return new Translation(NO_CODE_MARKER, key, NULL_LOG_COUNTER);
        }
        String message = bundle.getString(key);
        String code = bundle.getString(key + ".ID");
        if ("TBD".equals(code)) {
            return new Translation(TBD_MARKER, message, NULL_LOG_COUNTER);
        }
        return new Translation(MarkerFactory.getMarker(code), message, logCounterFactory.apply(code));
    }

    static Map<String, ?> getCache() {
        return CACHE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Translation translate(String key) {
        Translation existing = CACHE.get(key);
        if (existing != null) {
            return existing;
        }
        Map<String, Translation> map = CACHE;
        synchronized (map) {
            Translation existing2 = CACHE.get(key);
            if (existing2 != null) {
                return existing2;
            }
            Translation translated = I18nLogger.getTranslation(key);
            CACHE.put(key, translated);
            return translated;
        }
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    private static void delegate(Translation translation, MarkerTextAction action, Consumer<LogCounter> counterAction) {
        counterAction.accept(translation.getLogCounter());
        Marker m = translation.getMarker();
        if (!I18nLogger.isSuppressed(m)) {
            action.execute(m, translation.getText());
        }
    }

    private static void delegateTrace(String key, MarkerTextAction action) {
        I18nLogger.delegateTrace(I18nLogger.translate(key), action);
    }

    private static void delegateTrace(Translation translation, MarkerTextAction action) {
        I18nLogger.delegate(translation, action, LogCounter::incrementTrace);
    }

    private static void delegateDebug(String key, MarkerTextAction action) {
        I18nLogger.delegateDebug(I18nLogger.translate(key), action);
    }

    private static void delegateDebug(Translation translation, MarkerTextAction action) {
        I18nLogger.delegate(translation, action, LogCounter::incrementDebug);
    }

    private static void delegateInfo(String key, MarkerTextAction action) {
        I18nLogger.delegateInfo(I18nLogger.translate(key), action);
    }

    private static void delegateInfo(Translation translation, MarkerTextAction action) {
        I18nLogger.delegate(translation, action, LogCounter::incrementInfo);
    }

    private static void delegateWarn(String key, MarkerTextAction action) {
        I18nLogger.delegateWarn(I18nLogger.translate(key), action);
    }

    private static void delegateWarn(Translation translation, MarkerTextAction action) {
        I18nLogger.delegate(translation, action, LogCounter::incrementWarn);
    }

    private static void delegateError(String key, MarkerTextAction action) {
        I18nLogger.delegateError(I18nLogger.translate(key), action);
    }

    private static void delegateError(Translation translation, MarkerTextAction action) {
        I18nLogger.delegate(translation, action, LogCounter::incrementError);
    }

    private static boolean isSuppressed(Marker marker) {
        return SuppressionTracker.forThread().isSuppressed(marker.getName());
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public void trace(Translation translation) {
        if (this.isTraceEnabled()) {
            I18nLogger.delegateTrace(translation, this.delegate::trace);
        }
    }

    public void trace(Translation translation, Throwable t) {
        if (this.isTraceEnabled()) {
            I18nLogger.delegateTrace(translation, (Marker m, String s) -> this.delegate.trace(m, s, t));
        }
    }

    @Override
    public void trace(String key) {
        if (this.isTraceEnabled()) {
            I18nLogger.delegateTrace(key, this.delegate::trace);
        }
    }

    @Override
    public void trace(String key, Object arg) {
        if (this.isTraceEnabled()) {
            I18nLogger.delegateTrace(key, (Marker m, String t) -> this.delegate.trace(m, t, arg));
        }
    }

    @Override
    public void trace(String key, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            I18nLogger.delegateTrace(key, (Marker m, String t) -> this.delegate.trace(m, t, arg1, arg2));
        }
    }

    @Override
    public void trace(String key, Object ... arguments) {
        if (this.isTraceEnabled()) {
            I18nLogger.delegateTrace(key, (Marker m, String t) -> this.delegate.trace(m, t, arguments));
        }
    }

    @Override
    public void trace(String key, Throwable e) {
        if (this.isTraceEnabled()) {
            I18nLogger.delegateTrace(key, (Marker m, String t) -> this.delegate.trace(m, t, e));
        }
    }

    @Override
    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.trace(marker, msg);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.trace(marker, format, arg);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.trace(marker, format, arg1, arg2);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object ... arguments) {
        if (this.isTraceEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.trace(marker, format, arguments);
        }
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.trace(marker, msg, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public void debug(Translation translation) {
        if (this.isDebugEnabled()) {
            I18nLogger.delegateDebug(translation, this.delegate::debug);
        }
    }

    public void debug(Translation translation, Throwable t) {
        if (this.isDebugEnabled()) {
            I18nLogger.delegateDebug(translation, (Marker m, String s) -> this.delegate.debug(m, s, t));
        }
    }

    @Override
    public void debug(String key) {
        if (this.isDebugEnabled()) {
            I18nLogger.delegateDebug(key, this.delegate::debug);
        }
    }

    @Override
    public void debug(String key, Object arg) {
        if (this.isDebugEnabled()) {
            I18nLogger.delegateDebug(key, (Marker m, String t) -> this.delegate.debug(m, t, arg));
        }
    }

    @Override
    public void debug(String key, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            I18nLogger.delegateDebug(key, (Marker m, String t) -> this.delegate.debug(m, t, arg1, arg2));
        }
    }

    @Override
    public void debug(String key, Object ... arguments) {
        if (this.isDebugEnabled()) {
            I18nLogger.delegateDebug(key, (Marker m, String t) -> this.delegate.debug(m, t, arguments));
        }
    }

    @Override
    public void debug(String key, Throwable e) {
        if (this.isDebugEnabled()) {
            I18nLogger.delegateDebug(key, (Marker m, String t) -> this.delegate.debug(m, t, e));
        }
    }

    @Override
    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.debug(marker, msg);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.debug(marker, format, arg);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.debug(marker, format, arg1, arg2);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.debug(marker, format, arguments);
        }
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.debug(marker, msg, t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public void info(Translation translation) {
        if (this.isInfoEnabled()) {
            I18nLogger.delegateInfo(translation, this.delegate::info);
        }
    }

    public void info(Translation translation, Throwable t) {
        if (this.isInfoEnabled()) {
            I18nLogger.delegateInfo(translation, (Marker m, String s) -> this.delegate.info(m, s, t));
        }
    }

    @Override
    public void info(String key) {
        if (this.isInfoEnabled()) {
            I18nLogger.delegateInfo(key, this.delegate::info);
        }
    }

    @Override
    public void info(String key, Object arg) {
        if (this.isInfoEnabled()) {
            I18nLogger.delegateInfo(key, (Marker m, String t) -> this.delegate.info(m, t, arg));
        }
    }

    @Override
    public void info(String key, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            I18nLogger.delegateInfo(key, (Marker m, String t) -> this.delegate.info(m, t, arg1, arg2));
        }
    }

    @Override
    public void info(String key, Object ... arguments) {
        if (this.isInfoEnabled()) {
            I18nLogger.delegateInfo(key, (Marker m, String t) -> this.delegate.info(m, t, arguments));
        }
    }

    @Override
    public void info(String key, Throwable e) {
        if (this.isInfoEnabled()) {
            I18nLogger.delegateInfo(key, (Marker m, String t) -> this.delegate.info(m, t, e));
        }
    }

    @Override
    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.info(marker, msg);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.info(marker, format, arg);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.info(marker, format, arg1, arg2);
        }
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.info(marker, format, arguments);
        }
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.info(marker, msg, t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public void warn(Translation translation) {
        if (this.isWarnEnabled()) {
            I18nLogger.delegateWarn(translation, this.delegate::warn);
        }
    }

    public void warn(Translation translation, Throwable t) {
        if (this.isWarnEnabled()) {
            I18nLogger.delegateWarn(translation, (Marker m, String s) -> this.delegate.warn(m, s, t));
        }
    }

    @Override
    public void warn(String key) {
        if (this.isWarnEnabled()) {
            I18nLogger.delegateWarn(key, this.delegate::warn);
        }
    }

    @Override
    public void warn(String key, Object arg) {
        if (this.isWarnEnabled()) {
            I18nLogger.delegateWarn(key, (Marker m, String t) -> this.delegate.warn(m, t, arg));
        }
    }

    @Override
    public void warn(String key, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            I18nLogger.delegateWarn(key, (Marker m, String t) -> this.delegate.warn(m, t, arg1, arg2));
        }
    }

    @Override
    public void warn(String key, Object ... arguments) {
        if (this.isWarnEnabled()) {
            I18nLogger.delegateWarn(key, (Marker m, String t) -> this.delegate.warn(m, t, arguments));
        }
    }

    @Override
    public void warn(String key, Throwable e) {
        if (this.isWarnEnabled()) {
            I18nLogger.delegateWarn(key, (Marker m, String t) -> this.delegate.warn(m, t, e));
        }
    }

    @Override
    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.warn(marker, msg);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.warn(marker, format, arg);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.warn(marker, format, arg1, arg2);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.warn(marker, format, arguments);
        }
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.warn(marker, msg, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    public void error(Translation translation) {
        if (this.isErrorEnabled()) {
            I18nLogger.delegateError(translation, this.delegate::error);
        }
    }

    public void error(Translation translation, Throwable t) {
        if (this.isErrorEnabled()) {
            I18nLogger.delegateError(translation, (Marker m, String s) -> this.delegate.error(m, s, t));
        }
    }

    @Override
    public void error(String key) {
        if (this.isErrorEnabled()) {
            I18nLogger.delegateError(key, this.delegate::error);
        }
    }

    @Override
    public void error(String key, Object arg) {
        if (this.isErrorEnabled()) {
            I18nLogger.delegateError(key, (Marker m, String t) -> this.delegate.error(m, t, arg));
        }
    }

    @Override
    public void error(String key, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            I18nLogger.delegateError(key, (Marker m, String t) -> this.delegate.error(m, t, arg1, arg2));
        }
    }

    @Override
    public void error(String key, Object ... arguments) {
        if (this.isErrorEnabled()) {
            I18nLogger.delegateError(key, (Marker m, String t) -> this.delegate.error(m, t, arguments));
        }
    }

    @Override
    public void error(String key, Throwable e) {
        if (this.isErrorEnabled()) {
            I18nLogger.delegateError(key, (Marker m, String t) -> this.delegate.error(m, t, e));
        }
    }

    @Override
    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.error(marker, msg);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.error(marker, format, arg);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.error(marker, format, arg1, arg2);
        }
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.error(marker, format, arguments);
        }
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled() && !I18nLogger.isSuppressed(marker)) {
            this.delegate.error(marker, msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogCounterFactory(Function<String, LogCounter> lcf) {
        logCounterFactory = lcf;
        Map<String, Translation> map = CACHE;
        synchronized (map) {
            CACHE.clear();
        }
    }

    public static void removeLogCounterFactory() {
        I18nLogger.setLogCounterFactory(NULL_LOG_COUNTER_FACTORY);
    }

    @Immutable
    public static final class Translation {
        private final String text;
        private final Marker codeMarker;
        private final LogCounter logCounter;

        private Translation(Marker codeMarker, String text, LogCounter logCounter) {
            this.text = text;
            this.codeMarker = codeMarker;
            this.logCounter = logCounter;
        }

        LogCounter getLogCounter() {
            return this.logCounter;
        }

        Marker getMarker() {
            return this.codeMarker;
        }

        public String getText() {
            return this.text;
        }

        Translation withText(String alternativeText) {
            return new Translation(this.codeMarker, alternativeText, this.logCounter);
        }
    }

    @FunctionalInterface
    private static interface MarkerTextAction {
        public void execute(Marker var1, String var2);
    }
}

