/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.lockfree.utilities;

import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.util.concurrent.locks.LockSupport;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class BackOffIdleStrategy {
    private static final Logger LOG;
    private final int yieldThreshold;
    private final int parkThreshold;
    private final long backoffParkNanos;
    private final long backoffMaxParkNanos;
    private final boolean dontSpin;
    private final int blockingPollThreshold;

    public BackOffIdleStrategy() {
        this(ConfigurationUtils.getIntegerSystemProperty("diffusion.backoff.yield_threshold", 0), ConfigurationUtils.getIntegerSystemProperty("diffusion.backoff.park_threshold", 500), ConfigurationUtils.getLongSystemProperty("diffusion.backoff.park.nanos", 100000L), ConfigurationUtils.getLongSystemProperty("diffusion.backoff.max.park.nanos", 5000000L), ConfigurationUtils.getBooleanSystemProperty("diffusion.backoff.dont_spin"), ConfigurationUtils.getIntegerSystemProperty("diffusion.backoff.blocking_poll_threshold", 600));
    }

    BackOffIdleStrategy(int yieldThreshold, int parkThreshold, long backoffParkNanos, long backoffMaxParkNanos, boolean dontSpin, int blockingPollThreshold) {
        if (yieldThreshold < 0) {
            throw new IllegalArgumentException("yieldThreshold must be non-negative");
        }
        if (parkThreshold < 1) {
            throw new IllegalArgumentException("parkThreshold must be positive");
        }
        if (backoffParkNanos < 1L) {
            throw new IllegalArgumentException("backoffParkNanos must be positive");
        }
        if (backoffMaxParkNanos < backoffParkNanos) {
            throw new IllegalArgumentException("backoffMaxParkNanos < backoffParkNanos");
        }
        this.yieldThreshold = yieldThreshold;
        this.parkThreshold = parkThreshold;
        this.backoffParkNanos = backoffParkNanos;
        this.backoffMaxParkNanos = backoffMaxParkNanos;
        this.dontSpin = dontSpin;
        this.blockingPollThreshold = blockingPollThreshold;
    }

    public int idle(int counter) {
        return this.idle(counter, Long.MAX_VALUE);
    }

    public int idle(int counter, long maximumTime) {
        if (counter >= this.parkThreshold) {
            if (Thread.interrupted()) {
                throw new DiffusionInterruptedException();
            }
            LockSupport.parkNanos(Math.min(Math.min(this.backoffMaxParkNanos, this.backoffParkNanos * (long)(counter / this.parkThreshold)), maximumTime));
        } else if (this.dontSpin) {
            LockSupport.parkNanos(Math.min(this.backoffParkNanos, maximumTime));
        } else if (counter >= this.yieldThreshold) {
            Thread.yield();
        }
        return counter + 1;
    }

    public boolean willPark(int counter) {
        return counter > this.parkThreshold || this.dontSpin;
    }

    public int blockingPollThreshold() {
        return this.dontSpin ? 0 : this.blockingPollThreshold;
    }

    static {
        String[] legacyProperties;
        LOG = LoggerFactory.getLogger(BackOffIdleStrategy.class);
        for (String s : legacyProperties = new String[]{"diffusion.backoff.parked.spins", "diffusion.backoff.unparked.spins"}) {
            if (ConfigurationUtils.getSystemProperty(s) == null) continue;
            LOG.warn("Ignoring legacy property '{}'", (Object)s);
        }
    }
}

