/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.serialisation.impl;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.ReadSerialiser;
import com.pushtechnology.diffusion.io.serialisation.Serialiser;
import com.pushtechnology.diffusion.io.serialisation.WriteSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialiser<T>
implements Serialiser<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSerialiser.class);

    @Override
    public final T read(InputStream in) throws IOException {
        try {
            return this.readUnchecked(in);
        }
        catch (RuntimeException e) {
            LOG.trace("deserialisation error", e);
            throw new IOException(e);
        }
    }

    protected abstract T readUnchecked(InputStream var1) throws IOException;

    protected static final <T> void writeCollection(OutputStream out, WriteSerialiser<T> tSerialiser, Collection<? extends T> ts) throws IOException {
        EncodedDataCodec.writeInt32(out, ts.size());
        for (T t : ts) {
            tSerialiser.write(out, t);
        }
    }

    protected static final <T> void writeNullable(OutputStream out, WriteSerialiser<T> tSerialiser, T value) throws IOException {
        if (value == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            tSerialiser.write(out, value);
        }
    }

    protected static final <K, V> void writeMap(OutputStream out, WriteSerialiser<K> kSerialiser, WriteSerialiser<V> vSerialiser, Map<K, V> map) throws IOException {
        EncodedDataCodec.writeInt32(out, map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kSerialiser.write(out, entry.getKey());
            vSerialiser.write(out, entry.getValue());
        }
    }

    public static final void writeStringMap(OutputStream out, Map<String, String> map) throws IOException {
        AbstractSerialiser.writeMap(out, EncodedDataCodec::writeString, EncodedDataCodec::writeString, map);
    }

    protected static final <K, V> Map<K, V> readMap(InputStream in, ReadSerialiser<K> kSerialiser, ReadSerialiser<V> vSerialiser) throws IOException {
        int n = EncodedDataCodec.readInt32(in);
        if (n == 0) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(n);
        for (int i = 0; i < n; ++i) {
            map.put(kSerialiser.read(in), vSerialiser.read(in));
        }
        return map;
    }

    protected static final <K, V, M extends Map<K, V>> M readMap(InputStream in, ReadSerialiser<K> kSerialiser, ReadSerialiser<V> vSerialiser, Supplier<M> mapSupplier) throws IOException {
        int n = EncodedDataCodec.readInt32(in);
        Map map = (Map)mapSupplier.get();
        for (int i = 0; i < n; ++i) {
            map.put(kSerialiser.read(in), vSerialiser.read(in));
        }
        return (M)map;
    }

    public static final Map<String, String> readStringMap(InputStream in) throws IOException {
        return AbstractSerialiser.readMap(in, EncodedDataCodec::readString, EncodedDataCodec::readString);
    }

    protected static final <T> List<T> readList(InputStream in, ReadSerialiser<? extends T> tSerialiser) throws IOException {
        return AbstractSerialiser.readCollection(in, ArrayList::new, tSerialiser);
    }

    protected static final <T> T readNullable(InputStream in, ReadSerialiser<? extends T> tSerialiser) throws IOException {
        byte p = EncodedDataCodec.readByte(in);
        if (p == 0) {
            return null;
        }
        return tSerialiser.read(in);
    }

    protected static final <T, C extends Collection<? super T>> C readCollection(InputStream in, Function<Integer, C> factory, ReadSerialiser<? extends T> tSerialiser) throws IOException {
        int n = EncodedDataCodec.readInt32(in);
        Collection result = (Collection)factory.apply(n);
        for (int i = 0; i < n; ++i) {
            result.add(tSerialiser.read(in));
        }
        return (C)result;
    }

    protected static final <T extends Enum<T>> void writeEnums(OutputStream out, EnumConverter<T> converter, Collection<T> v) throws IOException {
        AbstractSerialiser.writeCollection(out, (o, x) -> EncodedDataCodec.writeByte(o, converter.toByte(x)), v);
    }

    protected static final <T extends Enum<T>> EnumSet<T> readEnumSet(Class<T> clazz, InputStream in, EnumConverter<T> converter) throws IOException {
        return AbstractSerialiser.readCollection(in, x -> EnumSet.noneOf(clazz), i -> converter.fromByte(EncodedDataCodec.readByte(in)));
    }

    protected static final void writeStrings(OutputStream out, Collection<String> ss) throws IOException {
        AbstractSerialiser.writeCollection(out, EncodedDataCodec::writeString, ss);
    }

    protected static final List<String> readStrings(InputStream in) throws IOException {
        return AbstractSerialiser.readList(in, EncodedDataCodec::readString);
    }

    public String toString() {
        Class<?> clazz = this.getClass();
        CommandSerialiser annotation = clazz.getAnnotation(CommandSerialiser.class);
        String simpleName = clazz.getSimpleName();
        if (annotation != null) {
            return simpleName + "[" + annotation.valueType().getSimpleName() + ", " + annotation.spec() + "]";
        }
        return simpleName;
    }
}

