/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.serialisation.common;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="boolean", valueType=Boolean.class)
public final class BooleanSerialiser
extends AbstractSerialiser<Boolean> {
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    @Override
    public Boolean readUnchecked(InputStream input) throws IOException {
        byte val = EncodedDataCodec.readByte(input);
        switch (val) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return Boolean.FALSE;
            }
        }
        throw new IOException("Expected Boolean serialisation but got " + val);
    }

    @Override
    public void write(OutputStream out, Boolean bool) throws IOException {
        EncodedDataCodec.writeByte(out, bool != false ? (byte)1 : 0);
    }
}

