/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.selector;

import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import net.jcip.annotations.Immutable;

@Immutable
public final class UnifiedSelectorParameters {
    private static final String SELECT_TIMEOUT_PROPERTY = "diffusion.selector.timeout";
    private static final boolean DISABLE_WAKEUP = ConfigurationUtils.getBooleanSystemProperty("diffusion.selector.disablewakeup");
    public static final String TASK_QUEUE_SIZE_PROPERTY = "diffusion.selector.task.queue.size";
    private static final boolean DISABLE_KEY_SET_OPTIMISATION = ConfigurationUtils.getBooleanSystemProperty("diffusion.selector.unoptimisedkeyset");
    public static final UnifiedSelectorParameters SELECT_NOW = UnifiedSelectorParameters.selectTimeout(-1L);
    private final long selectTimeout;
    private final boolean keySetOptimisationDisabled;
    private final boolean wakeupDisabled;
    private final boolean useWakeup;

    public static UnifiedSelectorParameters selectTimeout(long timeout) {
        return new UnifiedSelectorParameters(timeout, false, false);
    }

    private UnifiedSelectorParameters(long st, boolean disableKeySetOptimisation, boolean disableWakeup) {
        this.selectTimeout = ConfigurationUtils.getLongSystemProperty(SELECT_TIMEOUT_PROPERTY, st);
        this.keySetOptimisationDisabled = disableKeySetOptimisation | DISABLE_KEY_SET_OPTIMISATION;
        this.wakeupDisabled = disableWakeup | DISABLE_WAKEUP;
        this.useWakeup = this.selectTimeout == 0L || this.selectTimeout > 0L && !this.wakeupDisabled;
    }

    public UnifiedSelectorParameters disableKeySetOptimisation() {
        return new UnifiedSelectorParameters(this.selectTimeout, true, this.wakeupDisabled);
    }

    public UnifiedSelectorParameters disableWakeup() {
        return new UnifiedSelectorParameters(this.selectTimeout, this.keySetOptimisationDisabled, true);
    }

    public long getSelectTimeout() {
        return this.selectTimeout;
    }

    public boolean useWakeup() {
        return this.useWakeup;
    }

    public boolean isKeySetOptimisationDisabled() {
        return this.keySetOptimisationDisabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        if (this.selectTimeout < 0L) {
            sb.append("selectNow()");
        } else {
            sb.append("select(").append(this.selectTimeout).append(')');
        }
        if (this.keySetOptimisationDisabled) {
            sb.append("; key set optimisation disabled");
        }
        if (this.wakeupDisabled && this.selectTimeout >= 0L) {
            sb.append("; wake up disabled");
        }
        return sb.toString();
    }
}

