/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.nio;

import com.pushtechnology.diffusion.io.nio.ReadChannelHandler;
import com.pushtechnology.diffusion.io.nio.TaskControlSource;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class ReadControlSource
implements TaskControlSource<ReadControl, ReadChannelHandler> {
    public static final ReadControlSource READ_CONTROL = new ReadControlSource();
    private static final ReadControl PARTIAL_INSTANCE = new ReadControl(ReadControl.Action.PARTIAL);
    private static final ReadControl COMPLETE_INSTANCE = new ReadControl(ReadControl.Action.COMPLETE);
    private static final ReadControl CLOSE_INSTANCE = new ReadControl(ReadControl.Action.CLOSE);
    private static final ReadControl COMPLETE_REVERSE_INSTANCE = new ReadControl(ReadControl.Action.COMPLETE_REVERSE);

    private ReadControlSource() {
    }

    @Override
    public ReadControl switchHandler(ReadChannelHandler nextHandler) {
        return new SwitchHandlerReadControl(nextHandler);
    }

    @Override
    public ReadControl suspendedSwitchHandler(CompletableFuture<? extends ReadChannelHandler> resumeAction) {
        return new SuspendedReadControl<ReadChannelHandler>(ReadControl.Action.SUSPENDED_SWITCH_HANDLER, resumeAction);
    }

    @Override
    public ReadControl partial() {
        return PARTIAL_INSTANCE;
    }

    @Override
    public ReadControl complete() {
        return COMPLETE_INSTANCE;
    }

    @Override
    public ReadControl suspendedComplete(CompletableFuture<?> resumeAction) {
        return new SuspendedReadControl(ReadControl.Action.SUSPENDED_COMPLETE, resumeAction);
    }

    @Override
    public ReadControl close() {
        return CLOSE_INSTANCE;
    }

    @Override
    public ReadControl completeReverse() {
        return COMPLETE_REVERSE_INSTANCE;
    }

    private final class SwitchHandlerReadControl
    extends ReadControl {
        private final ReadChannelHandler nextHandler;

        private SwitchHandlerReadControl(ReadChannelHandler nextHandler) {
            super(ReadControl.Action.SWITCH_HANDLER);
            this.nextHandler = nextHandler;
        }

        @Override
        ReadChannelHandler getNextHandler() {
            return this.nextHandler;
        }
    }

    private final class SuspendedReadControl<T>
    extends ReadControl {
        private final CompletableFuture<T> resumeAction;

        SuspendedReadControl(ReadControl.Action action, CompletableFuture<T> resumeAction) {
            super(action);
            this.resumeAction = resumeAction;
        }

        @Override
        CompletableFuture<?> resumeAction() {
            return this.resumeAction;
        }
    }

    public static class ReadControl {
        private final Action action;

        private ReadControl(Action action) {
            this.action = action;
        }

        Action getAction() {
            return this.action;
        }

        ReadChannelHandler getNextHandler() {
            throw new UnsupportedOperationException();
        }

        CompletableFuture<?> resumeAction() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.action.name();
        }

        static enum Action {
            CLOSE,
            COMPLETE_REVERSE,
            SWITCH_HANDLER,
            SUSPENDED_SWITCH_HANDLER,
            PARTIAL,
            COMPLETE,
            SUSPENDED_COMPLETE;

        }
    }
}

