/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.nio;

import com.pushtechnology.diffusion.io.nio.CompleteReverseReadChannelHandler;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.ReadChannelHandler;
import com.pushtechnology.diffusion.io.nio.ReadControlSource;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.util.concurrent.threads.ExecutionPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public final class InboundTask
implements Runnable {
    private static final Logger LOG = I18nLogger.getLogger(InboundTask.class);
    private static final ByteBuffer PROCESSING = ByteBuffer.allocate(0);
    private static final ByteBuffer CLOSING = ByteBuffer.allocate(0);
    private volatile ByteBuffer remainder;
    private static final AtomicReferenceFieldUpdater<InboundTask, ByteBuffer> REMAINDER = AtomicReferenceFieldUpdater.newUpdater(InboundTask.class, ByteBuffer.class, "remainder");
    private volatile ReadChannelHandler handler;
    private volatile boolean readRequired;
    private final ExecutionPool inboundThreadPool;
    private final int bufferCapacity;

    public InboundTask(ExecutionPool inboundThreadPool, int bufferCapacity, ReadChannelHandler handler) {
        this(inboundThreadPool, bufferCapacity, handler, null);
    }

    InboundTask(ExecutionPool inboundThreadPool, int bufferCapacity, ReadChannelHandler handler, ByteBuffer initialBuffer) {
        this.inboundThreadPool = inboundThreadPool;
        this.bufferCapacity = bufferCapacity;
        this.handler = handler;
        this.remainder = initialBuffer;
        this.readRequired = initialBuffer == null;
    }

    @Override
    public void run() {
        ReadChannelHandler firstHandler = this.handler;
        NetworkChannel channel = firstHandler.getChannel();
        ByteBuffer buffer = this.reserveBuffer(channel);
        boolean read = this.readRequired;
        this.readRequired = true;
        LOG.trace("'{}' entered, buffer={}, readRequired={}, channel={}", this, buffer, read, channel);
        if (read) {
            int result;
            assert (buffer.limit() == buffer.capacity()) : buffer;
            try {
                result = channel.read(buffer);
            }
            catch (IOException e) {
                this.closeIfOpen(channel, firstHandler, e);
                this.release(buffer, channel);
                return;
            }
            catch (Throwable thr) {
                LOG.error("IO_NIO_UNABLE_TO_PROCESS_READ", (Object)this, (Object)thr);
                channel.close();
                this.release(buffer, channel);
                return;
            }
            if (result == -1) {
                firstHandler.handleEOF();
                this.closeIfOpen(channel, firstHandler);
                this.release(buffer, channel);
                return;
            }
            if (result == 0) {
                LOG.trace("'{}' read no bytes {}", (Object)this, (Object)buffer);
                if (buffer.position() == 0) {
                    this.release(buffer, channel);
                } else {
                    this.storeOrRelease(buffer, channel);
                }
                channel.registerForRead();
                return;
            }
            LOG.trace("'{}' after read {}", (Object)this, (Object)buffer);
            buffer.flip();
        }
        while ((channel = this.handleInput(buffer, channel)) != null) {
        }
    }

    private NetworkChannel handleInput(ByteBuffer buffer, NetworkChannel channel) {
        ReadControlSource.ReadControl control;
        if (channel.isInputShutdown()) {
            this.release(buffer, channel);
            return null;
        }
        try {
            control = this.handler.handleInput(buffer);
        }
        catch (IOException e) {
            this.closeIfOpen(channel, this.handler, e);
            this.release(buffer, channel);
            return null;
        }
        catch (Throwable thr) {
            LOG.error("IO_NIO_UNABLE_TO_PROCESS_READ", (Object)this, (Object)thr);
            channel.close();
            this.release(buffer, channel);
            return null;
        }
        LOG.trace("'{}' returned {}, buffer={}", this, control, buffer);
        switch (control.getAction()) {
            case SWITCH_HANDLER: {
                return this.handleSwitchHandler(buffer, control, channel);
            }
            case SUSPENDED_SWITCH_HANDLER: {
                return this.handleSuspendedSwitchHandler(buffer, control, channel);
            }
            case PARTIAL: {
                return this.handlePartial(buffer, channel);
            }
            case COMPLETE: {
                return this.handleComplete(buffer, channel);
            }
            case SUSPENDED_COMPLETE: {
                return this.handleSuspendComplete(buffer, control, channel);
            }
            case COMPLETE_REVERSE: {
                return this.handleCompleteReverse(channel, buffer);
            }
        }
        return this.handleClose(channel, buffer);
    }

    private NetworkChannel handleSwitchHandler(ByteBuffer buffer, ReadControlSource.ReadControl control, NetworkChannel channel) {
        ReadChannelHandler nextHandler = control.getNextHandler();
        LOG.trace("nextHandler={}", (Object)nextHandler);
        Object previousKey = this.handler.inboundThreadAffinityKey();
        this.handler = nextHandler;
        Object affinityKey = nextHandler.inboundThreadAffinityKey();
        if (affinityKey != previousKey) {
            this.readRequired = false;
            this.storeOrRelease(buffer, channel);
            this.schedule(affinityKey);
            return null;
        }
        return nextHandler.getChannel();
    }

    private NetworkChannel handleSuspendedSwitchHandler(ByteBuffer buffer, ReadControlSource.ReadControl control, NetworkChannel channel) {
        if (buffer.hasRemaining()) {
            this.storeOrRelease(buffer, channel);
            this.readRequired = false;
        } else {
            this.release(buffer, channel);
        }
        control.resumeAction().whenComplete((nextHandler, failed) -> {
            if (nextHandler instanceof ReadChannelHandler) {
                ReadChannelHandler rch = (ReadChannelHandler)nextHandler;
                LOG.trace("'{}' handleSuspendedSwitchHandler resumed, next handler={}, remainder={}", this, nextHandler, this.remainder);
                this.handler = rch;
                this.schedule(rch.inboundThreadAffinityKey());
            } else {
                LOG.trace("'{}' handleSuspendedSwitchHandler cancelled", (Object)this);
                this.close();
            }
        });
        return null;
    }

    private NetworkChannel handlePartial(ByteBuffer buffer, NetworkChannel channel) {
        if (buffer.capacity() - buffer.position() <= channel.minimumReadBufferSize()) {
            int newBufferSize = buffer.capacity() * 2;
            if (LOG.isWarnEnabled()) {
                LOG.warn("IO_NIO_MESSAGE_EXCEED_INPUT_BUFFER", (Object)newBufferSize, (Object)channel);
            }
            ByteBuffer largeBuffer = channel.bufferForReading(newBufferSize);
            buffer.flip();
            largeBuffer.put(buffer);
            channel.directBufferPool().release(buffer);
            this.storeOrRelease(largeBuffer, channel);
        } else {
            buffer.limit(buffer.capacity());
            this.storeOrRelease(buffer, channel);
        }
        channel.registerForRead();
        return null;
    }

    private NetworkChannel handleComplete(ByteBuffer buffer, NetworkChannel channel) {
        this.warnIfRemaining(buffer);
        this.release(buffer, channel);
        channel.registerForRead();
        return null;
    }

    private NetworkChannel handleSuspendComplete(ByteBuffer buffer, ReadControlSource.ReadControl control, NetworkChannel channel) {
        this.warnIfRemaining(buffer);
        this.release(buffer, channel);
        control.resumeAction().whenComplete((complete, failed) -> {
            if (failed == null) {
                this.handler.getChannel().registerForRead();
            } else {
                LOG.trace("'{}' handleSuspendComplete cancelled", (Object)this);
                this.close();
            }
        });
        return null;
    }

    private NetworkChannel handleClose(NetworkChannel channel, ByteBuffer buffer) {
        this.closeIfOpen(channel, this.handler);
        this.release(buffer, channel);
        return null;
    }

    private NetworkChannel handleCompleteReverse(NetworkChannel channel, ByteBuffer buffer) {
        this.release(buffer, channel);
        this.handler = CompleteReverseReadChannelHandler.INSTANCE;
        return null;
    }

    private ByteBuffer reserveBuffer(NetworkChannel channel) {
        ByteBuffer reserved = REMAINDER.getAndSet(this, PROCESSING);
        if (reserved == null) {
            return channel.bufferForReading(this.bufferCapacity);
        }
        assert (reserved != PROCESSING && reserved != CLOSING) : "PROCESSING";
        return reserved;
    }

    private void closeIfOpen(NetworkChannel channel, ReadChannelHandler h, IOException e) {
        if (channel.isOpen()) {
            h.closeTaskOnError(e);
            LOG.trace("'{}' closed", (Object)this, (Object)e);
        }
    }

    private void closeIfOpen(NetworkChannel channel, ReadChannelHandler h) {
        if (channel.isOpen()) {
            h.closeTask();
            LOG.trace("'{}' closed", (Object)this);
        }
    }

    private void release(ByteBuffer buffer, NetworkChannel channel) {
        channel.directBufferPool().release(buffer);
        ByteBuffer r = this.remainder;
        assert (r == null || r == buffer || r == PROCESSING || r == CLOSING) : r;
        REMAINDER.set(this, null);
    }

    private void storeOrRelease(ByteBuffer buffer, NetworkChannel channel) {
        if (!REMAINDER.compareAndSet(this, PROCESSING, buffer)) {
            channel.directBufferPool().release(buffer);
        }
    }

    private void warnIfRemaining(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            LOG.debug("{}: {} left unprocessed bytes in buffer {}", this, this.handler, buffer);
        }
    }

    public void onConnectionTimeout() {
        ReadChannelHandler h = this.handler;
        if (h.isConnectionHandler() && h.getChannel().isOpen()) {
            this.close(new InterruptedByTimeoutException());
        }
    }

    void close() {
        ReadChannelHandler h = this.handler;
        this.closeIfOpen(h.getChannel(), h);
        this.releaseRemainder(h);
    }

    void close(IOException reason) {
        ReadChannelHandler h = this.handler;
        this.closeIfOpen(h.getChannel(), h, reason);
        this.releaseRemainder(h);
    }

    private void releaseRemainder(ReadChannelHandler h) {
        ByteBuffer r;
        while (true) {
            if ((r = this.remainder) == null || r == CLOSING) {
                return;
            }
            if (r == PROCESSING) {
                if (!REMAINDER.compareAndSet(this, r, CLOSING)) continue;
                return;
            }
            if (REMAINDER.compareAndSet(this, r, null)) break;
        }
        this.release(r, h.getChannel());
    }

    void schedule() {
        assert (this.handler.getChannel() != null) : "InboundTask handler channel was null but selector was registered for read";
        this.schedule(this.handler.inboundThreadAffinityKey());
    }

    private void schedule(Object affinityKey) {
        this.inboundThreadPool.execute(affinityKey, this);
    }

    public String toString() {
        return String.format("%s@%x %s", this.getClass().getSimpleName(), this.hashCode(), this.handler);
    }
}

