/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.nio;

import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import com.pushtechnology.diffusion.io.nio.InboundTask;
import com.pushtechnology.diffusion.io.nio.KeyAttachment;
import com.pushtechnology.diffusion.io.nio.NIOConnector;
import com.pushtechnology.diffusion.io.nio.ReadChannelHandler;
import com.pushtechnology.diffusion.io.nio.SelectedKeyProcessor;
import com.pushtechnology.diffusion.io.nio.SelectedKeyProcessorFactory;
import com.pushtechnology.diffusion.io.nio.SelectorOpCallback;
import com.pushtechnology.diffusion.io.nio.UnifiedSelector;
import com.pushtechnology.diffusion.io.selector.SelectorTask;
import com.pushtechnology.diffusion.io.selector.UnifiedSelectorParameters;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.util.concurrent.threads.ExecutionPool;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocalThread;
import com.pushtechnology.diffusion.util.concurrent.threads.UncaughtExceptionLogger;
import com.pushtechnology.diffusion.utils.listener.COWListListenerSupport;
import com.pushtechnology.diffusion.utils.listener.ListenerSupport;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractUnifiedSelector<Q extends Queue<SelectorTask>>
implements UnifiedSelector {
    private static final Logger LOG = I18nLogger.getLogger(AbstractUnifiedSelector.class);
    private final Selector selector;
    private final UnifiedSelectorParameters parameters;
    private final AtomicReference<InternalState> state = new AtomicReference<InternalState>(InternalState.INITIAL);
    private final ListenerSupport<Runnable> exitListeners = new COWListListenerSupport<Runnable>();
    private final Q requestQueue;
    private final Thread thread;
    private final SelectedKeyProcessor keyProcessor;

    protected AbstractUnifiedSelector(String name, Q queue, UnifiedSelectorParameters parameters) {
        this.parameters = parameters;
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open a new selector", e);
        }
        this.keyProcessor = SelectedKeyProcessorFactory.createKeyProcessor(this.selector, parameters.isKeySetOptimisationDisabled());
        this.requestQueue = queue;
        this.thread = new FastThreadLocalThread(new SelectorRunnable(), name);
        this.thread.setUncaughtExceptionHandler(new UncaughtExceptionLogger());
        this.thread.setDaemon(true);
    }

    @Override
    public final void start() {
        if (this.changeState(InternalState.INITIAL, InternalState.RUNNING)) {
            this.thread.start();
        }
    }

    @Override
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    public final void stop(long timeoutMillis) {
        LOG.info("IO_NIO_SELECTOR_STOPPING", (Object)this);
        try {
            this.selector.close();
        }
        catch (IOException | NullPointerException e) {
            LOG.info("IO_NIO_SELECTOR_CLOSE_SELECTOR_FAILURE", (Object)this, (Object)e);
        }
        if (this.thread != Thread.currentThread()) {
            long halfTimeout = timeoutMillis / 2L;
            if (AbstractUnifiedSelector.tryJoin(this.thread, halfTimeout == 0L ? 10000L : halfTimeout)) {
                return;
            }
            this.thread.interrupt();
            if (AbstractUnifiedSelector.tryJoin(this.thread, halfTimeout)) {
                return;
            }
            LOG.error("IO_NIO_SELECTOR_SHUTDOWN_FAILURE", (Object)this);
        }
    }

    private static boolean tryJoin(Thread thread, long timeout) {
        try {
            thread.join(timeout);
        }
        catch (InterruptedException e) {
            throw new DiffusionInterruptedException(e);
        }
        return !thread.isAlive();
    }

    @Override
    public final boolean isRunning() {
        return this.state.get().equals((Object)InternalState.RUNNING);
    }

    @Override
    public final void request(SelectorTask task) {
        if (!this.isRunning()) {
            LOG.debug("{}: ignoring request({}), state is {}", this, task, this.state);
        } else {
            if (this.thread == Thread.currentThread()) {
                this.processTask(this.selector, task);
            } else if (!this.requestQueue.offer((SelectorTask)task)) {
                try {
                    this.putRequest(this.requestQueue, task);
                }
                catch (InterruptedException e) {
                    throw new DiffusionInterruptedException(e);
                }
            }
            if (this.parameters.useWakeup()) {
                this.selector.wakeup();
            }
        }
    }

    void addExitListener(Runnable listener) {
        this.exitListeners.add(listener);
    }

    @Override
    public final void registerForAccept(NIOConnector connector, ServerSocketChannel serverSocketChannel) {
        this.addExitListener(() -> connector.stop());
        this.request(s -> {
            try {
                serverSocketChannel.register(s, 16, connector);
            }
            catch (ClosedChannelException e) {
                throw new IllegalStateException("Unable to register server socket channel", e);
            }
        });
    }

    @Override
    public final void registerForInitialRead(ExecutionPool inboundThreadPool, int bufferCapacity, ReadChannelHandler initialHandler, ByteBuffer initialBuffer) {
        InboundTask task = new InboundTask(inboundThreadPool, bufferCapacity, initialHandler, initialBuffer);
        SocketChannel socketChannel = initialHandler.getChannel().getSocketChannel();
        KeyAttachment attachment = new KeyAttachment(task);
        this.request(s -> {
            LOG.trace("registering {} with selector {}", (Object)initialHandler, (Object)this);
            try {
                socketChannel.configureBlocking(false);
                socketChannel.register(s, 0, attachment);
            }
            catch (IOException e) {
                LOG.debug("Unable to process registration ", e);
                task.close(e);
                return;
            }
            task.schedule();
            LOG.trace("dispatched first task for {}", (Object)task);
        });
    }

    @Override
    public final void registerForRead(SelectableChannel channel) {
        this.request(s -> {
            SelectionKey key = channel.keyFor(s);
            if (key != null && key.isValid()) {
                int prevOps = key.interestOps();
                key.interestOps(prevOps | 1);
            }
        });
    }

    @Override
    public final void registerForWrite(SelectableChannel channel, SelectorOpCallback callbacks) {
        this.request(s -> {
            SelectionKey key = channel.keyFor(s);
            if (key != null && key.isValid()) {
                int prevOps = key.interestOps();
                key.interestOps(prevOps | 4);
                ((KeyAttachment)key.attachment()).setWriteCallback(callbacks);
            }
        });
    }

    @Override
    public final void cancel(SelectableChannel channel) {
        this.request(s -> {
            SelectionKey key = channel.keyFor(s);
            if (key != null) {
                key.cancel();
            }
        });
    }

    public final int keyCount() {
        if (this.isRunning()) {
            try {
                return this.selector.keys().size();
            }
            catch (ClosedSelectorException e) {
                return 0;
            }
        }
        return 0;
    }

    protected abstract void putRequest(Q var1, SelectorTask var2) throws InterruptedException;

    protected abstract void runProcessing(Q var1, Selector var2, SelectedKeyProcessor var3, UnifiedSelectorParameters var4) throws IOException;

    protected final boolean processTasks(Selector s) {
        SelectorTask element = (SelectorTask)this.requestQueue.poll();
        if (element == null) {
            return false;
        }
        do {
            this.processTask(s, element);
        } while ((element = (SelectorTask)this.requestQueue.poll()) != null);
        return true;
    }

    protected final void processTask(Selector s, SelectorTask task) {
        try {
            task.run(s);
        }
        catch (DiffusionInterruptedException | ClosedSelectorException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("IO_NIO_SELECTOR_TASK_FAILURE", (Object)this, (Object)e);
        }
    }

    private boolean changeState(InternalState previous, InternalState next) {
        if (!this.state.compareAndSet(previous, next)) {
            LOG.debug("{}: Failed to transition from {} to {}; currently {}", new Object[]{this, previous, next, this.state});
            return false;
        }
        LOG.debug("{}: {} -> {}", new Object[]{this, previous, next});
        return true;
    }

    public String toString() {
        return this.thread.getName();
    }

    private static enum InternalState {
        INITIAL,
        RUNNING,
        STOPPING,
        STOPPED;

    }

    private final class SelectorRunnable
    implements Runnable {
        private SelectorRunnable() {
        }

        @Override
        public void run() {
            LOG.debug("Starting selector with parameters {}", (Object)AbstractUnifiedSelector.this.parameters);
            try {
                AbstractUnifiedSelector.this.runProcessing(AbstractUnifiedSelector.this.requestQueue, AbstractUnifiedSelector.this.selector, AbstractUnifiedSelector.this.keyProcessor, AbstractUnifiedSelector.this.parameters);
            }
            catch (ClosedSelectorException e) {
                LOG.trace("Selector closed");
            }
            catch (DiffusionInterruptedException e) {
                LOG.debug("Stopping due to interrrupt", e);
            }
            catch (IOException e) {
                LOG.error("IO_NIO_SELECTOR_THREAD_FAILURE", (Object)AbstractUnifiedSelector.this, (Object)e);
            }
            finally {
                AbstractUnifiedSelector.this.changeState(InternalState.RUNNING, InternalState.STOPPING);
                try {
                    AbstractUnifiedSelector.this.selector.close();
                }
                catch (IOException e) {
                    LOG.debug("Failed to close selector", e);
                }
                AbstractUnifiedSelector.this.changeState(InternalState.STOPPING, InternalState.STOPPED);
                AbstractUnifiedSelector.this.exitListeners.apply(Runnable::run);
            }
        }
    }
}

