/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.encoding;

import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import com.pushtechnology.diffusion.utils.FastEncoder;
import com.pushtechnology.diffusion.utils.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class EncodedDataCodec {
    private static final FastThreadLocal<byte[]> THREAD_LOCAL_BYTE_ARRAY = FastThreadLocal.withInitial(() -> new byte[64]);

    private EncodedDataCodec() {
    }

    public static void writeByte(OutputStream out, byte value) throws IOException {
        out.write(value);
    }

    public static byte readByte(InputStream in) throws IOException {
        int i = in.read();
        if (i == -1) {
            throw new IOException("Stream exhausted");
        }
        return (byte)i;
    }

    public static void writeInt32(OutputStream out, int value) throws IOException {
        int v = value;
        while (true) {
            if (((long)v & 0xFFFFFFFFFFFFFF80L) == 0L) {
                out.write(v);
                return;
            }
            out.write(v & 0x7F | 0x80);
            v >>>= 7;
        }
    }

    public static int readInt32(InputStream in) throws IOException {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            byte i = EncodedDataCodec.readByte(in);
            result |= (i & 0x7F) << shift;
            if ((i & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed int32");
    }

    public static void writeInt32(ByteBuffer out, int value) {
        int v = value;
        while (true) {
            if (((long)v & 0xFFFFFFFFFFFFFF80L) == 0L) {
                out.put((byte)v);
                return;
            }
            out.put((byte)(v & 0x7F | 0x80));
            v >>>= 7;
        }
    }

    public static int readInt32(ByteBuffer in) throws IOException {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            byte i = in.get();
            result |= (i & 0x7F) << shift;
            if ((i & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed int32");
    }

    public static int lengthOfEncodedInt32(int v) {
        if (v < 0) {
            return 5;
        }
        if (v < 128) {
            return 1;
        }
        if (v < 16384) {
            return 2;
        }
        if (v < 0x200000) {
            return 3;
        }
        if (v < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public static void writeInt64(OutputStream out, long value) throws IOException {
        long v = value;
        while (true) {
            if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
                out.write((int)v);
                return;
            }
            out.write((int)(v & 0x7FL) | 0x80);
            v >>>= 7;
        }
    }

    public static long readInt64(InputStream in) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte i = EncodedDataCodec.readByte(in);
            result |= (long)(i & 0x7F) << shift;
            if ((i & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed int64");
    }

    public static void writeDouble(OutputStream out, double value) throws IOException {
        EncodedDataCodec.writeInt64(out, Double.doubleToLongBits(value));
    }

    public static double readDouble(InputStream in) throws IOException {
        return Double.longBitsToDouble(EncodedDataCodec.readInt64(in));
    }

    public static int lengthOfEncodedInt64(long v) {
        if (v < 0L) {
            return 10;
        }
        if (v < 128L) {
            return 1;
        }
        if (v < 16384L) {
            return 2;
        }
        if (v < 0x200000L) {
            return 3;
        }
        if (v < 0x10000000L) {
            return 4;
        }
        if (v < 0x800000000L) {
            return 5;
        }
        if (v < 0x40000000000L) {
            return 6;
        }
        if (v < 0x2000000000000L) {
            return 7;
        }
        if (v < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public static void writeByteArray(OutputStream out, byte[] bytes) throws IOException {
        EncodedDataCodec.writeInt32(out, bytes.length);
        out.write(bytes, 0, bytes.length);
    }

    public static byte[] readByteArray(InputStream in) throws IOException {
        return IOUtils.readByteArray(in, EncodedDataCodec.readInt32(in));
    }

    public static void writeString(OutputStream out, String s) throws IOException {
        EncodedDataCodec.writeInt32(out, FastEncoder.utf8Length(s));
        FastEncoder.utf8Encode(s, out);
    }

    public static String readString(InputStream in) throws IOException {
        int length = EncodedDataCodec.readInt32(in);
        byte[] bytes = EncodedDataCodec.temporaryBytes(length);
        IOUtils.readByteArray(in, bytes, length);
        return CharsetUtils.bytesUTF8ToString(bytes, 0, length);
    }

    private static byte[] temporaryBytes(int length) {
        byte[] cached = THREAD_LOCAL_BYTE_ARRAY.get();
        if (cached.length >= length) {
            return cached;
        }
        byte[] larger = new byte[length];
        THREAD_LOCAL_BYTE_ARRAY.set(larger);
        return larger;
    }

    public static void writeBoolean(OutputStream out, boolean value) throws IOException {
        out.write(value ? 1 : 0);
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        byte b1 = EncodedDataCodec.readByte(in);
        if (b1 == 0) {
            return false;
        }
        if (b1 == 1) {
            return true;
        }
        throw new IOException("Malformed boolean");
    }
}

