/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.bytes;

import com.pushtechnology.diffusion.io.bytes.ArrayUtilities;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamOverflowException;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class IBytesOutputStreamImpl
extends IBytesOutputStream {
    private static final FastThreadLocal<IBytesOutputStreamImpl> THREAD_LOCAL = FastThreadLocal.withInitial(IBytesOutputStreamImpl::new);
    private byte[] buffer;
    private int count;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public static IBytesOutputStreamImpl forThread() {
        IBytesOutputStreamImpl result = THREAD_LOCAL.get();
        result.reset();
        return result;
    }

    public IBytesOutputStreamImpl() {
        this(32);
    }

    public IBytesOutputStreamImpl(int initialBufferSize) {
        this.buffer = new byte[initialBufferSize];
    }

    @Override
    public void write(int b) {
        this.ensureCapacityFor(1);
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b) {
        this.writeUnchecked(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        ArrayUtilities.checkBounds(b, off, len);
        this.writeUnchecked(b, off, len);
    }

    private void writeUnchecked(byte[] b, int off, int len) {
        this.ensureCapacityFor(len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    private void ensureCapacityFor(int additionalCapacity) {
        if (additionalCapacity > this.buffer.length - this.count) {
            this.grow(additionalCapacity);
        }
    }

    private void grow(int additionalCapacity) {
        this.buffer = Arrays.copyOf(this.buffer, IBytesOutputStreamImpl.bufferSizeFor(this.buffer.length, this.count + additionalCapacity));
    }

    static int bufferSizeFor(int oldCapacity, int minimumCapacity) {
        if (minimumCapacity - 0x7FFFFFF7 > 0) {
            throw new IBytesOutputStreamOverflowException();
        }
        int doubleCapacity = oldCapacity << 1;
        if (doubleCapacity - minimumCapacity < 0) {
            return minimumCapacity;
        }
        if (doubleCapacity - 0x7FFFFFF7 > 0) {
            return 0x7FFFFFF7;
        }
        return doubleCapacity;
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void copyTo(ByteBuffer bb) {
        bb.put(this.buffer, 0, this.length());
    }

    @Override
    public void copyTo(OutputStream stream) throws IOException {
        stream.write(this.buffer, 0, this.length());
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public IBytes toIBytes() {
        if (this.count == 0) {
            return IBytes.EMPTY_BYTES;
        }
        return IBytes.toIBytes(Arrays.copyOf(this.buffer, this.count));
    }

    @Override
    public String fromUTF8() {
        return CharsetUtils.bytesUTF8ToString(this.buffer, 0, this.length());
    }

    public String toString() {
        return "[" + this.length() + " bytes]";
    }
}

