/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.bytes;

import com.pushtechnology.diffusion.io.bytes.ArrayUtilities;
import com.pushtechnology.diffusion.io.bytes.HasArray;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class IBytesInputStream
extends InputStream {
    public IBytes toBytes() {
        return this.toBytes(Integer.MAX_VALUE);
    }

    public abstract IBytes toBytes(int var1);

    public final int read(ByteBuffer buffer) {
        return this.read(buffer, this.available());
    }

    public abstract int read(ByteBuffer var1, int var2);

    public abstract Object recordMark();

    public abstract void resetToMark(Object var1);

    @Override
    public abstract int read();

    @Override
    public final int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        try {
            return super.read(b, off, len);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long skip(long n) {
        try {
            return super.skip(n);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final void close() {
    }

    @Override
    public abstract int available();

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public abstract void mark(int var1);

    @Override
    public abstract void reset();

    public final boolean nextBytesEqual(IBytesInputStream other, int count) {
        if (this == other) {
            return true;
        }
        if (this instanceof HasArray && other instanceof HasArray) {
            HasArray a = (HasArray)((Object)this);
            HasArray b = (HasArray)((Object)other);
            if (count > b.length()) {
                return false;
            }
            return ArrayUtilities.arrayStartsWith(a.bytes(), a.offset(), a.length(), b.bytes(), b.offset(), count);
        }
        return this.nextBytesEqualNoBackingArray(other, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nextBytesEqualNoBackingArray(IBytesInputStream other, int count) {
        Object mark = this.recordMark();
        Object otherMark = other.recordMark();
        try {
            for (int i = 0; i < count; ++i) {
                int r1 = this.read();
                if (r1 != -1 && r1 == other.read()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.resetToMark(mark);
            other.resetToMark(otherMark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextBytesEqual(byte[] other) {
        Object mark = this.recordMark();
        try {
            for (byte b : other) {
                if (this.read() == (b & 0xFF)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.resetToMark(mark);
        }
    }
}

