/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.bytes;

import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.EmptyIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesInputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public interface IBytes
extends Bytes {
    public static final IBytes EMPTY_BYTES = new EmptyIBytes();

    public static byte[] toByteArray(Bytes bytes) {
        if (bytes instanceof IBytes) {
            return ((IBytes)bytes).toByteArrayInternal();
        }
        return bytes.toByteArray();
    }

    public static IBytes toIBytes(Bytes bytes) {
        if (bytes instanceof IBytes) {
            return (IBytes)bytes;
        }
        return IBytes.toIBytes(bytes.toByteArray());
    }

    public static IBytes toIBytes(byte[] bytes) {
        return ArrayIBytes.toArrayIBytes(bytes);
    }

    @Override
    public IBytesInputStream asInputStream();

    public void copyTo(ByteBuffer var1) throws BufferOverflowException, ReadOnlyBufferException;

    public byte[] toByteArrayInternal();

    public void appendHex(StringBuilder var1, int var2);

    public boolean contains(IBytes var1, int var2);

    public boolean sharesBytesWith(IBytes var1);

    public boolean equalBytes(IBytes var1);
}

