/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.bytes;

import com.pushtechnology.diffusion.io.bytes.HasArray;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesInputStream;

public abstract class AbstractIBytes
implements IBytes,
Comparable<IBytes> {
    @Override
    public byte[] toByteArrayInternal() {
        return this.toByteArray();
    }

    @Override
    public boolean contains(IBytes subValue, int start) {
        if (start + subValue.length() > this.length()) {
            return false;
        }
        if (subValue instanceof HasArray) {
            return this.contains((HasArray)((Object)subValue), start);
        }
        IBytesInputStream valueStream = this.asInputStreamAfter(start);
        IBytesInputStream subValueStream = subValue.asInputStream();
        while (subValueStream.available() > 0) {
            if (valueStream.read() == subValueStream.read()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean sharesBytesWith(IBytes other) {
        return false;
    }

    private boolean contains(HasArray subValue, int start) {
        IBytesInputStream valueStream = this.asInputStreamAfter(start);
        byte[] subarray = subValue.bytes();
        int subarrayOffset = subValue.offset();
        for (int i = 0; i < subValue.length(); ++i) {
            if (valueStream.read() == (subarray[i + subarrayOffset] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    private IBytesInputStream asInputStreamAfter(int offset) {
        IBytesInputStream valueStream = this.asInputStream();
        long skipped = valueStream.skip(offset);
        assert (skipped == (long)offset);
        return valueStream;
    }

    public int hashCode() {
        int result = this.length();
        try (IBytesInputStream s = this.asInputStream();){
            while (true) {
                int b;
                if ((b = s.read()) == -1) {
                    int n = result;
                    return n;
                }
                result = 31 * result + b;
            }
        }
    }

    public boolean equals(Object o) {
        return o instanceof IBytes && this.equalBytes((IBytes)o);
    }

    @Override
    public boolean equalBytes(IBytes other) {
        return other == this || this.length() == other.length() && this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(IBytes o) {
        if (this instanceof HasArray && o instanceof HasArray) {
            return AbstractIBytes.compareTo((HasArray)((Object)this), (HasArray)((Object)o));
        }
        IBytesInputStream s1 = this.asInputStream();
        IBytesInputStream s2 = o.asInputStream();
        try {
            while (true) {
                int n;
                int b1 = s1.read();
                int b2 = s2.read();
                if (b1 == -1) {
                    n = b2 == -1 ? 0 : -1;
                    return n;
                }
                if (b2 == -1) {
                    n = 1;
                    return n;
                }
                int cmp = b1 - b2;
                if (cmp == 0) continue;
                int n2 = cmp;
                return n2;
            }
        }
        finally {
            s1.close();
            s2.close();
        }
    }

    private static int compareTo(HasArray a, HasArray b) {
        byte[] aBytes = a.bytes();
        int aOffset = a.offset();
        int aLength = a.length();
        byte[] bBytes = b.bytes();
        int bOffset = b.offset();
        int bLength = b.length();
        int n = aOffset + Math.min(aLength, bLength);
        int i = aOffset;
        int j = bOffset;
        while (i < n) {
            int cmp = Byte.compare(aBytes[i], bBytes[j]);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return aLength - bLength;
    }

    public String toString() {
        return "[" + this.length() + " bytes]";
    }
}

