/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.bytebuffer.serialisation;

import com.pushtechnology.diffusion.io.bytebuffer.serialisation.AbstractByteBufferDeserialiser;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.ByteBufferDeserialiser;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.DeserialisationException;
import java.nio.ByteBuffer;
import net.jcip.annotations.Immutable;

@Immutable
public final class CompositeByteBufferDeserialiser
extends AbstractByteBufferDeserialiser {
    private final ByteBufferDeserialiser[] delegates;

    public static ByteBufferDeserialiser of(ByteBufferDeserialiser ... delegates) {
        return new CompositeByteBufferDeserialiser(delegates);
    }

    private CompositeByteBufferDeserialiser(ByteBufferDeserialiser[] delegates) {
        this.delegates = delegates;
    }

    @Override
    public Object doRead(ByteBuffer source) throws DeserialisationException {
        int start = source.position();
        for (ByteBufferDeserialiser deserialiser : this.delegates) {
            Object deserialised = deserialiser.read(source);
            if (ByteBufferDeserialiser.DeserialisationResult.decode(deserialised) != ByteBufferDeserialiser.DeserialisationResult.UNRECOGNISED) {
                return deserialised;
            }
            source.position(start);
        }
        return ByteBufferDeserialiser.DeserialisationResult.UNRECOGNISED;
    }
}

