/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.http;

import com.pushtechnology.diffusion.java8.LambdaCheckedExceptionWorkarounds;
import com.pushtechnology.diffusion.utils.FastEncoderCore;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.function.IntPredicate;

public final class URIEncoder {
    private static final byte REPLACEMENT = 95;
    private static final BitSet UNRESERVED;
    private static final BitSet UNRESERVED_AND_SLASH;

    private URIEncoder() {
    }

    public static void percentEncode(String s, OutputStream out) throws IOException {
        URIEncoder.percentEncode(s, b -> URIEncoder.write(out, b), UNRESERVED::get);
    }

    public static void percentEncodePath(String s, OutputStream out) throws IOException {
        URIEncoder.percentEncode(s, b -> URIEncoder.write(out, b), UNRESERVED_AND_SLASH::get);
    }

    private static void write(OutputStream out, int b) {
        try {
            out.write(b);
        }
        catch (IOException e) {
            LambdaCheckedExceptionWorkarounds.sneakyThrow(e);
        }
    }

    public static void percentEncode(String s, ByteBuffer out) {
        URIEncoder.percentEncode(s, out::put, UNRESERVED::get);
    }

    public static void percentEncodePath(String s, ByteBuffer out) {
        URIEncoder.percentEncode(s, out::put, UNRESERVED_AND_SLASH::get);
    }

    private static void percentEncode(String s, ByteWriter out, IntPredicate dontEncode) {
        int end = s.length();
        for (int i = 0; i < end; ++i) {
            char c = s.charAt(i);
            if (!dontEncode.test(c)) {
                URIEncoder.percentEncode(s, i, end, out, dontEncode);
                return;
            }
            out.write((byte)c);
        }
    }

    private static void percentEncode(String s, int start, int end, ByteWriter out, IntPredicate dontEncode) {
        int i = start;
        do {
            char c;
            if ((c = s.charAt(i)) < '\u0080') {
                if (dontEncode.test(c)) {
                    out.write((byte)c);
                    continue;
                }
                URIEncoder.writeEncodedCharacter(out, c);
                continue;
            }
            if (c < '\u0800') {
                URIEncoder.writeEncodedCharacter(out, 0xC0 | c >> 6);
                URIEncoder.writeEncodedCharacter(out, 0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                int uc = FastEncoderCore.parseSurrogateSequence(c, s, i, end);
                if (uc < 0) {
                    out.write((byte)95);
                    continue;
                }
                URIEncoder.writeEncodedCharacter(out, 0xF0 | uc >> 18);
                URIEncoder.writeEncodedCharacter(out, 0x80 | uc >> 12 & 0x3F);
                URIEncoder.writeEncodedCharacter(out, 0x80 | uc >> 6 & 0x3F);
                URIEncoder.writeEncodedCharacter(out, 0x80 | uc & 0x3F);
                ++i;
                continue;
            }
            URIEncoder.writeEncodedCharacter(out, 0xE0 | c >> 12);
            URIEncoder.writeEncodedCharacter(out, 0x80 | c >> 6 & 0x3F);
            URIEncoder.writeEncodedCharacter(out, 0x80 | c & 0x3F);
        } while (++i < end);
    }

    private static void writeEncodedCharacter(ByteWriter out, int c) {
        out.write((byte)37);
        out.write(URIEncoder.hexDigit(c >> 4 & 0xF));
        out.write(URIEncoder.hexDigit(c & 0xF));
    }

    private static byte hexDigit(int digit) {
        return (byte)(digit < 10 ? 48 + digit : 55 + digit);
    }

    static {
        int i;
        UNRESERVED = new BitSet(128);
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(95);
        UNRESERVED.set(126);
        UNRESERVED_AND_SLASH = (BitSet)UNRESERVED.clone();
        UNRESERVED_AND_SLASH.set(47);
    }

    @FunctionalInterface
    private static interface ByteWriter {
        public void write(byte var1);
    }
}

