/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway.control;

import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.gateway.Gateway;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface GatewayControl
extends Feature {
    public CompletableFuture<ClientConfiguration> getConfiguration(SessionId var1);

    public CompletableFuture<ClientStatus> getStatus(SessionId var1);

    public CompletableFuture<ClientOperations> getOperations(SessionId var1);

    public CompletableFuture<Gateway.OperationDetail> getOperationDetail(SessionId var1, String var2);

    public CompletableFuture<OperationResponse> invokeOperation(SessionId var1, String var2, String var3);

    public CompletableFuture<List<ClientKey>> getClients();

    public CompletableFuture<List<ClientDetail>> getClientDetails(Set<String> var1, Set<String> var2);

    public CompletableFuture<ClientServiceTypes> getServiceTypes(SessionId var1);

    public CompletableFuture<ClientServices> getServices(SessionId var1);

    public CompletableFuture<ClientConfiguration> getServiceConfiguration(SessionId var1, Gateway.ServiceId var2);

    public CompletableFuture<ClientStatus> getServiceStatus(SessionId var1, Gateway.ServiceId var2);

    public CompletableFuture<ClientOperations> getServiceOperations(SessionId var1, Gateway.ServiceId var2);

    public CompletableFuture<Gateway.OperationDetail> getServiceOperationDetail(SessionId var1, Gateway.ServiceId var2, String var3);

    public CompletableFuture<OperationResponse> invokeServiceOperation(SessionId var1, Gateway.ServiceId var2, String var3, String var4);

    public CompletableFuture<Gateway.ServiceDetail> addService(SessionId var1, String var2, String var3, String var4, String var5);

    public CompletableFuture<Gateway.ServiceDetail> updateService(SessionId var1, Gateway.ServiceId var2, String var3, String var4);

    public CompletableFuture<?> removeService(SessionId var1, Gateway.ServiceId var2);

    public CompletableFuture<?> registerClient(String var1, String var2);

    public CompletableFuture<?> removeClient(String var1, String var2);

    public static interface ClientServices {
        public List<Gateway.ServiceDetail> getServices();
    }

    public static interface ClientServiceTypes {
        public List<Gateway.ServiceType> getServiceTypes();
    }

    public static interface ConnectedClientDetails {
        public String getActiveSessionId();

        public Set<String> getPassiveSessionIds();

        public Gateway.ConfigurationMode getConfigurationMode();
    }

    public static interface ClientDetail {
        public ClientKey getKey();

        public ConnectedClientDetails getConnectedClientDetails();
    }

    public static interface ClientKey {
        public String getType();

        public String getId();
    }

    public static interface OperationResponse {
        public String getOutput();
    }

    public static interface ClientOperations {
        public List<Gateway.Operation> getOperations();
    }

    public static interface ClientStatus {
        public List<Gateway.StatusItem> getStatusItems();
    }

    public static interface ClientConfiguration {
        public String getSchema();

        public String getConfiguration();
    }
}

