/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.command.commands.gateway.GatewayResponse;
import com.pushtechnology.diffusion.command.commands.gateway.services.RemoveServiceRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.RemoveServiceResponse;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.gateway.AbstractGatewayResponder;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.GatewayRegistry;
import com.pushtechnology.diffusion.gateway.GatewayRequestHandler;
import net.jcip.annotations.Immutable;

@Immutable
final class RemoveServiceRequestHandler
implements GatewayRequestHandler<RemoveServiceRequest> {
    private final GatewayRegistry theRegistry;

    RemoveServiceRequestHandler(GatewayRegistry registry) {
        this.theRegistry = registry;
    }

    @Override
    public void handleRequest(RemoveServiceRequest request, Gateway.RequestStream requestStream, CommandService.ServiceCallback<GatewayResponse> callback) {
        Gateway.ServiceId serviceId = request.getServiceId();
        if (!this.theRegistry.hasService(serviceId)) {
            callback.respond(RemoveServiceResponse.REMOVE_SERVICE_RESPONSE);
            return;
        }
        ((Gateway.ServiceRequestStream)requestStream).removeService(serviceId.getType(), serviceId.getName(), new RemoveServiceResponderImpl(serviceId, callback));
    }

    private final class RemoveServiceResponderImpl
    extends AbstractGatewayResponder
    implements Gateway.RemoveServiceResponder {
        private final Gateway.ServiceId theServiceId;

        private RemoveServiceResponderImpl(Gateway.ServiceId serviceId, CommandService.ServiceCallback<GatewayResponse> callback) {
            super(callback);
            this.theServiceId = serviceId;
        }

        @Override
        public void respond() {
            RemoveServiceRequestHandler.this.theRegistry.removeService(this.theServiceId);
            this.respond(RemoveServiceResponse.REMOVE_SERVICE_RESPONSE);
        }
    }
}

