/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.GatewayRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class GatewayRegistryImpl
implements GatewayRegistry {
    @GuardedBy(value="this")
    private Gateway.RequestStream theRequestStream = null;
    @GuardedBy(value="this")
    private final Map<String, Gateway.ServiceType> theServiceTypes = new LinkedHashMap<String, Gateway.ServiceType>();
    @GuardedBy(value="this")
    private final Map<Gateway.ServiceId, Gateway.Service> theServices = new TreeMap<Gateway.ServiceId, Gateway.Service>(new Comparator<Gateway.ServiceId>(){

        @Override
        public int compare(Gateway.ServiceId id1, Gateway.ServiceId id2) {
            int compareType = id1.getType().compareTo(id2.getType());
            return compareType == 0 ? id1.getName().compareTo(id2.getName()) : compareType;
        }
    });

    @Override
    public synchronized void validateRegister(Gateway.RequestStream requestStream) {
        if (this.theRequestStream != null) {
            throw new IllegalStateException("Already registered");
        }
        if (Objects.requireNonNull(requestStream, "requestStream is null") instanceof Gateway.ServiceRequestStream) {
            throw new IllegalArgumentException("This method cannot be used to register a ServiceRequestStream");
        }
    }

    @Override
    public synchronized void register(Gateway.RequestStream requestStream) {
        if (this.theRequestStream != null) {
            throw new IllegalStateException("Already registered");
        }
        this.theRequestStream = requestStream;
    }

    @Override
    public synchronized void validateRegister(Gateway.ServiceRequestStream requestStream, List<Gateway.ServiceType> serviceTypes) {
        Objects.requireNonNull(requestStream, "requestStream is null");
        if (this.theRequestStream != null) {
            throw new IllegalStateException("Already registered");
        }
        if (Objects.requireNonNull(serviceTypes, "serviceTypes is null").isEmpty()) {
            throw new IllegalArgumentException("At least one service type must be registered");
        }
        HashMap typeMap = new HashMap();
        serviceTypes.forEach(type -> {
            String typeName = type.getName();
            if (typeMap.putIfAbsent(typeName, type) != null) {
                throw new IllegalArgumentException("Duplicate service type '" + typeName + "'");
            }
        });
    }

    @Override
    public synchronized void register(Gateway.ServiceRequestStream requestStream, List<Gateway.ServiceType> serviceTypes, List<Gateway.Service> services) {
        if (this.theRequestStream != null) {
            throw new IllegalStateException("Already registered");
        }
        Objects.requireNonNull(services, "services is null");
        serviceTypes.forEach(type -> this.theServiceTypes.put(type.getName(), (Gateway.ServiceType)type));
        services.forEach(service -> {
            Gateway.ServiceId serviceId = service.getDetail().getId();
            if (service.getRequestStream() instanceof Gateway.ServiceRequestStream) {
                this.clear();
                throw new IllegalArgumentException("Request stream for service '" + String.valueOf(serviceId) + "' must not be a ServiceRequestStream");
            }
            if (this.theServiceTypes.containsKey(serviceId.getType())) {
                if (this.theServices.putIfAbsent(serviceId, (Gateway.Service)service) != null) {
                    this.clear();
                    throw new IllegalArgumentException("Duplicate service '" + String.valueOf(serviceId) + "'");
                }
            } else {
                this.clear();
                throw new IllegalArgumentException("Service '" + String.valueOf(serviceId) + "' has an undeclared service type");
            }
        });
        this.theRequestStream = requestStream;
    }

    @Override
    public synchronized Gateway.RequestStream getRequestStream() {
        return this.theRequestStream;
    }

    @Override
    public synchronized List<Gateway.ServiceType> getServiceTypes() {
        return new ArrayList<Gateway.ServiceType>(this.theServiceTypes.values());
    }

    @Override
    public synchronized boolean hasServiceType(String serviceType) {
        return this.theServiceTypes.containsKey(serviceType);
    }

    @Override
    public boolean hasService(Gateway.ServiceId serviceId) {
        return this.theServices.containsKey(serviceId);
    }

    @Override
    public synchronized List<Gateway.Service> getServices() {
        return new ArrayList<Gateway.Service>(this.theServices.values());
    }

    @Override
    public synchronized Gateway.RequestStream getServiceRequestStream(Gateway.ServiceId serviceId) {
        Gateway.Service service = this.theServices.get(serviceId);
        return service != null ? service.getRequestStream() : null;
    }

    @Override
    public synchronized void addService(Gateway.Service service) {
        Gateway.ServiceId serviceId = service.getDetail().getId();
        if (service.getRequestStream() instanceof Gateway.ServiceRequestStream) {
            throw new IllegalArgumentException("Request stream for service '" + String.valueOf(serviceId) + "' must not be a ServiceRequestStream");
        }
        if (this.theServiceTypes.containsKey(serviceId.getType())) {
            if (this.theServices.putIfAbsent(serviceId, service) != null) {
                throw new IllegalArgumentException("Service '" + String.valueOf(serviceId) + "' already exists");
            }
        } else {
            throw new IllegalArgumentException("Service '" + String.valueOf(serviceId) + "' has an undeclared service type");
        }
    }

    @Override
    public synchronized void replaceService(Gateway.Service service) {
        Gateway.ServiceId serviceId = service.getDetail().getId();
        if (service.getRequestStream() instanceof Gateway.ServiceRequestStream) {
            throw new IllegalArgumentException("Request stream for service '" + String.valueOf(serviceId) + "' must not be a ServiceRequestStream");
        }
        if (this.theServices.computeIfPresent(serviceId, (k, v) -> {
            Gateway.RequestStream oldRequestStream = v.getRequestStream();
            if (oldRequestStream != service.getRequestStream()) {
                oldRequestStream.onClose();
            }
            return service;
        }) == null) {
            throw new IllegalArgumentException("Service '" + String.valueOf(serviceId) + "' did not already exist");
        }
    }

    @Override
    public synchronized void removeService(Gateway.ServiceId serviceId) {
        Gateway.Service service = this.theServices.remove(serviceId);
        if (service != null) {
            service.getRequestStream().onClose();
        }
    }

    @Override
    public synchronized void deregister() {
        if (this.theRequestStream != null) {
            this.theRequestStream.onClose();
            this.theServices.forEach((k, v) -> v.getRequestStream().onClose());
            this.theRequestStream = null;
            this.clear();
        }
    }

    private void clear() {
        this.theServiceTypes.clear();
        this.theServices.clear();
    }
}

