/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayResponse;
import com.pushtechnology.diffusion.command.commands.gateway.services.AddServiceRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.AddServiceResponse;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.gateway.AbstractGatewayResponder;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.GatewayRegistry;
import com.pushtechnology.diffusion.gateway.GatewayRequestHandler;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
final class AddServiceRequestHandler
implements GatewayRequestHandler<AddServiceRequest> {
    private final GatewayRegistry theRegistry;

    AddServiceRequestHandler(GatewayRegistry registry) {
        this.theRegistry = registry;
    }

    @Override
    public void handleRequest(AddServiceRequest request, Gateway.RequestStream requestStream, CommandService.ServiceCallback<GatewayResponse> callback) {
        Gateway.ServiceDetail detail = request.getServiceDetail();
        Gateway.ServiceId serviceId = detail.getId();
        String serviceType = serviceId.getType();
        if (!this.theRegistry.hasServiceType(serviceType)) {
            callback.fail(ErrorReasonException.REJECTED_REQUEST, "Service type '" + serviceType + "' is not supported");
            return;
        }
        if (this.theRegistry.hasService(serviceId)) {
            callback.fail(ErrorReasonException.REJECTED_REQUEST, "Service '" + String.valueOf(serviceId) + "' already exists");
            return;
        }
        ((Gateway.ServiceRequestStream)requestStream).addService(serviceType, serviceId.getName(), detail.getDescription(), detail.getConfiguration(), new AddServiceResponderImpl(callback));
    }

    private final class AddServiceResponderImpl
    extends AbstractGatewayResponder
    implements Gateway.AddServiceResponder {
        private AddServiceResponderImpl(CommandService.ServiceCallback<GatewayResponse> callback) {
            super(callback);
        }

        @Override
        public void respond(Gateway.Service service) {
            AddServiceRequestHandler.this.theRegistry.addService(Objects.requireNonNull(service, "service is null"));
            this.respond(new AddServiceResponse(service.getDetail()));
        }
    }
}

