/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.flowcontrol;

import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import com.pushtechnology.diffusion.flowcontrol.FlowControl;
import com.pushtechnology.diffusion.flowcontrol.FlowMeasurement;
import com.pushtechnology.diffusion.flowcontrol.FlowMeasurementLogger;
import com.pushtechnology.diffusion.flowcontrol.PressureCalculator;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class SleepingFlowControl
implements FlowControl {
    private static final int LOG_PERIOD_MS = ConfigurationUtils.getIntegerSystemProperty("diffusion.flowcontrol.logperiod", 30000);
    private static final Logger LOG = LoggerFactory.getLogger(SleepingFlowControl.class);
    private final FlowMeasurement measurement;
    private final long sleepTime;
    private final PressureCalculator strategy;
    private final ScheduledExecutorService scheduledExecutor;
    @GuardedBy(value="this")
    private Future<?> scheduledTask;

    SleepingFlowControl(int sleepTime, PressureCalculator calculator, FlowMeasurement measurement, ScheduledExecutorService scheduledExecutor) {
        this.measurement = measurement;
        this.sleepTime = sleepTime;
        this.strategy = calculator;
        this.scheduledExecutor = scheduledExecutor;
    }

    @Override
    public void apply() {
        double pressure = this.measurement.toPressure(this.strategy);
        long t = (long)(pressure * (double)this.sleepTime);
        if (t > 0L) {
            LOG.debug("pressure={} => sleep for {} ms", (Object)pressure, (Object)t);
            try {
                Thread.sleep(t);
            }
            catch (InterruptedException e) {
                throw new DiffusionInterruptedException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLogging() {
        SleepingFlowControl sleepingFlowControl = this;
        synchronized (sleepingFlowControl) {
            if (this.scheduledTask == null) {
                FlowMeasurementLogger logger = new FlowMeasurementLogger(this.measurement);
                this.scheduledTask = this.scheduledExecutor.scheduleWithFixedDelay(logger.logTask(), LOG_PERIOD_MS, LOG_PERIOD_MS, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLogging() {
        SleepingFlowControl sleepingFlowControl = this;
        synchronized (sleepingFlowControl) {
            if (this.scheduledTask != null) {
                this.scheduledTask.cancel(false);
                this.scheduledTask = null;
            }
        }
    }
}

