/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.flowcontrol;

import com.pushtechnology.diffusion.flowcontrol.FlowMeasurement;
import com.pushtechnology.diffusion.flowcontrol.PressureCalculator;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@Immutable
final class CompositeFlowMeasurement
implements FlowMeasurement {
    private final FlowMeasurement[] delegates;

    CompositeFlowMeasurement(FlowMeasurement ... delegates) {
        this.delegates = delegates;
    }

    @Override
    public double toPressure(PressureCalculator calculator) {
        double reduction = 0.0;
        for (FlowMeasurement d : this.delegates) {
            reduction = Math.max(reduction, d.toPressure(calculator));
        }
        return reduction;
    }

    public String toString() {
        return String.format("highestOf(%s)", Arrays.toString(this.delegates));
    }
}

