/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl.schema;

import com.pushtechnology.diffusion.datatype.recordv2.impl.model.MutableRecordModelImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.FieldImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.RecordImpl;
import com.pushtechnology.diffusion.datatype.recordv2.model.MutableRecordModel;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class SchemaImpl
implements Schema {
    private final Map<String, RecordImpl> theRecords = new LinkedHashMap<String, RecordImpl>();
    private final RecordImpl theFirstRecord;
    private final RecordImpl theLastRecord;

    SchemaImpl(List<RecordImpl> records) {
        for (RecordImpl record : records) {
            this.theRecords.put(record.getName(), record);
        }
        this.theFirstRecord = records.get(0);
        this.theLastRecord = records.get(records.size() - 1);
    }

    @Override
    public List<Schema.Record> getRecords() {
        return new ArrayList<Schema.Record>(this.theRecords.values());
    }

    @Override
    public MutableRecordModel createMutableModel() {
        return new MutableRecordModelImpl(this);
    }

    public Collection<RecordImpl> records() {
        return this.theRecords.values();
    }

    public RecordImpl getRecord(String name) throws SchemaViolationException {
        RecordImpl record = this.theRecords.get(Objects.requireNonNull(name));
        if (record == null) {
            throw new SchemaViolationException("Record '" + name + "' is not known");
        }
        return record;
    }

    public RecordImpl firstRecord() {
        return this.theFirstRecord;
    }

    public RecordImpl lastRecord() {
        return this.theLastRecord;
    }

    public List<List<String>> createModel() {
        ArrayList<List<String>> model = new ArrayList<List<String>>(this.theRecords.size());
        for (RecordImpl record : this.theRecords.values()) {
            List<String> recordValue = record.createModel();
            int min = record.getMin();
            if (min <= 0) continue;
            model.add(recordValue);
            for (int i = 1; i < min; ++i) {
                model.add(new ArrayList<String>(recordValue));
            }
        }
        return model;
    }

    public int hashCode() {
        return this.theRecords.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaImpl other = (SchemaImpl)obj;
        return this.theRecords.equals(other.theRecords);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Schema [Records=").append(this.theRecords);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String asJSONString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("{\"records\":[");
        Iterator<Map.Entry<String, RecordImpl>> recordIterator = this.theRecords.entrySet().iterator();
        while (recordIterator.hasNext()) {
            RecordImpl record = recordIterator.next().getValue();
            sb.append("{\"name\":\"").append(SchemaImpl.escape(record.getName())).append("\",");
            if (record.getMin() == record.getMax()) {
                sb.append("\"occurs\":").append(record.getMin());
            } else {
                sb.append("\"min\":").append(record.getMin()).append(",\"max\":").append(record.getMax());
            }
            sb.append(",\"fields\":[");
            Iterator<FieldImpl> fieldsIterator = record.fields().iterator();
            while (fieldsIterator.hasNext()) {
                FieldImpl field = fieldsIterator.next();
                sb.append("{\"name\":\"").append(SchemaImpl.escape(field.getName())).append("\",").append("\"type\":\"").append((Object)field.getType()).append("\",");
                if (field.getMin() == field.getMax()) {
                    sb.append("\"occurs\":").append(field.getMin());
                } else {
                    sb.append("\"min\":").append(field.getMin()).append(",\"max\":").append(field.getMax());
                }
                if (field.getType() == Schema.Field.Type.DECIMAL) {
                    sb.append(",\"scale\":").append(field.getScale());
                }
                sb.append('}');
                if (fieldsIterator.hasNext()) {
                    sb.append(',');
                    continue;
                }
                sb.append(']');
            }
            sb.append('}');
            if (recordIterator.hasNext()) {
                sb.append(',');
                continue;
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }

    private static String escape(String string) {
        return string.replace("\"", "\\\"");
    }
}

