/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl.schema;

import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.FieldImpl;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class RecordImpl
implements Schema.Record {
    private final String theName;
    private final int theMin;
    private final int theMax;
    private final int theIndex;
    private final Map<String, FieldImpl> theFields = new LinkedHashMap<String, FieldImpl>();
    private final FieldImpl theLastField;

    RecordImpl(String name, int min, int max, int index, List<FieldImpl> fields) {
        this.theName = name;
        this.theMin = min;
        this.theMax = max;
        this.theIndex = index;
        for (FieldImpl field : fields) {
            this.theFields.put(field.getName(), field);
        }
        this.theLastField = fields.get(fields.size() - 1);
    }

    @Override
    public String getName() {
        return this.theName;
    }

    @Override
    public int getMin() {
        return this.theMin;
    }

    @Override
    public int getMax() {
        return this.theMax;
    }

    @Override
    public boolean isVariable() {
        return this.theMin != this.theMax;
    }

    public int getIndex() {
        return this.theIndex;
    }

    @Override
    public List<Schema.Field> getFields() {
        return new ArrayList<Schema.Field>(this.theFields.values());
    }

    public Collection<FieldImpl> fields() {
        return this.theFields.values();
    }

    public List<String> createModel() {
        ArrayList<String> fields = new ArrayList<String>(this.theFields.size());
        for (FieldImpl field : this.theFields.values()) {
            String value = field.modelValue();
            for (int i = 0; i < field.getMin(); ++i) {
                fields.add(value);
            }
        }
        return fields;
    }

    public FieldImpl getField(String name) throws SchemaViolationException {
        FieldImpl field = this.theFields.get(Objects.requireNonNull(name));
        if (field == null) {
            throw new SchemaViolationException("Record '" + this.getName() + "' has no field named '" + name + "'");
        }
        return field;
    }

    public FieldImpl lastField() {
        return this.theLastField;
    }

    public int getAbsoluteIndex(int index) {
        if (index < 0 || this.theMax != -1 && index > this.theMax - 1) {
            throw new IndexOutOfBoundsException("Invalid index '" + index + "' for record '" + this.theName + "'");
        }
        return this.theIndex + index;
    }

    public int hashCode() {
        return Objects.hash(this.theName, this.theMin, this.theMax, this.theFields, this.theIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecordImpl other = (RecordImpl)obj;
        return this.theName.equals(other.theName) && this.theMin == other.theMin && this.theMax == other.theMax && this.theFields.equals(other.theFields) && this.theIndex == other.theIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("Record [Name=").append(this.theName);
        if (this.theMin == this.theMax) {
            sb.append(", Occurs=").append(this.theMin);
        } else {
            sb.append(", Min=").append(this.theMin).append(", Max=");
            if (this.theMax == -1) {
                sb.append("Unlimited");
            } else {
                sb.append(this.theMax);
            }
        }
        sb.append(", Fields=").append(this.theFields);
        sb.append(']');
        return sb.toString();
    }
}

