/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl.schema;

import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import java.math.BigDecimal;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class FieldImpl
implements Schema.Field {
    private final String theName;
    private final Schema.Field.Type theType;
    private final int theMin;
    private final int theMax;
    private final int theScale;
    private final int theIndex;

    FieldImpl(String name, Schema.Field.Type type, int min, int max, int scale, int index) {
        this.theName = name;
        this.theType = type;
        this.theMin = min;
        this.theMax = max;
        this.theScale = scale;
        this.theIndex = index;
    }

    @Override
    public String getName() {
        return this.theName;
    }

    @Override
    public Schema.Field.Type getType() {
        return this.theType;
    }

    @Override
    public int getMin() {
        return this.theMin;
    }

    @Override
    public int getMax() {
        return this.theMax;
    }

    @Override
    public int getScale() {
        return this.theScale;
    }

    @Override
    public boolean isVariable() {
        return this.theMin != this.theMax;
    }

    public int getIndex() {
        return this.theIndex;
    }

    String modelValue() {
        switch (this.theType) {
            case DECIMAL: {
                return this.decimalModelValue();
            }
            case INTEGER: {
                return "0";
            }
            case STRING: {
                return "";
            }
        }
        return "";
    }

    private String decimalModelValue() {
        switch (this.theScale) {
            case 1: {
                return "0.0";
            }
            case 2: {
                return "0.00";
            }
            case 3: {
                return "0.000";
            }
        }
        StringBuilder sb = new StringBuilder(this.theScale + 2);
        sb.append("0.");
        for (int i = 0; i < this.theScale; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public String normalize(String value) throws SchemaViolationException {
        Objects.requireNonNull(value);
        switch (this.theType) {
            case DECIMAL: {
                try {
                    return new BigDecimal(value).setScale(this.theScale, 4).toString();
                }
                catch (NumberFormatException ex) {
                    throw new SchemaViolationException("Invalid decimal value " + value, ex);
                }
            }
            case INTEGER: {
                try {
                    return Integer.toString(Integer.parseInt(value));
                }
                catch (NumberFormatException ex) {
                    throw new SchemaViolationException("Invalid integer value " + value, ex);
                }
            }
            case STRING: {
                return value;
            }
        }
        return "";
    }

    public int getAbsoluteIndex(int index) {
        if (index < 0 || this.theMax != -1 && index > this.theMax - 1) {
            throw new IndexOutOfBoundsException("Invalid index '" + index + "' for field '" + this.theName + "'");
        }
        return this.theIndex + index;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.theName, this.theType, this.theMin, this.theMax, this.theScale, this.theIndex});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldImpl other = (FieldImpl)obj;
        return this.theName.equals(other.theName) && this.theType == other.theType && this.theMin == other.theMin && this.theMax == other.theMax && this.theScale == other.theScale && this.theIndex == other.theIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("Field [Name=").append(this.theName).append(", Type=").append((Object)this.theType);
        if (this.theMin == this.theMax) {
            sb.append(", Occurs=").append(this.theMin);
        } else {
            sb.append(", Min=").append(this.theMin).append(", Max=");
            if (this.theMax == -1) {
                sb.append("Unlimited");
            } else {
                sb.append(this.theMax);
            }
        }
        if (this.theType == Schema.Field.Type.DECIMAL) {
            sb.append(", Scale=").append(this.theScale);
        }
        sb.append(']');
        return sb.toString();
    }
}

