/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl.model;

import com.pushtechnology.diffusion.datatype.recordv2.impl.model.AbstractRecordModel;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.FieldImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.RecordImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.SchemaImpl;
import com.pushtechnology.diffusion.datatype.recordv2.model.MutableRecordModel;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import java.util.ArrayList;
import java.util.List;

public class MutableRecordModelImpl
extends AbstractRecordModel
implements MutableRecordModel {
    private final List<List<String>> theModel;

    public MutableRecordModelImpl(SchemaImpl schema) {
        super(schema);
        this.theModel = schema.createModel();
    }

    @Override
    protected List<List<String>> model() {
        return this.theModel;
    }

    @Override
    public MutableRecordModel set(String recordName, int recordIndex, String fieldName, int fieldIndex, String value) throws SchemaViolationException {
        RecordImpl schemaRecord = this.schema().getRecord(recordName);
        List<String> record = this.getRecord(schemaRecord, recordIndex);
        FieldImpl schemaField = schemaRecord.getField(fieldName);
        record.set(MutableRecordModelImpl.resolveFieldIndex(schemaField, record, fieldIndex), schemaField.normalize(value));
        return this;
    }

    @Override
    public MutableRecordModel set(String key, String value) throws SchemaViolationException, IllegalArgumentException, NumberFormatException {
        AbstractRecordModel.Key parsedKey = this.parseKey(key);
        return this.set(parsedKey.getRecordName(), parsedKey.getRecordIndex(), parsedKey.getFieldName(), parsedKey.getFieldIndex(), value);
    }

    @Override
    public MutableRecordModel add(String recordName, int recordIndex, String ... values) throws SchemaViolationException {
        if (values.length != 0) {
            RecordImpl schemaRecord = this.schema().getRecord(recordName);
            List<String> record = this.getRecord(schemaRecord, recordIndex);
            MutableRecordModelImpl.addValuesToRecord(schemaRecord, record, values);
        }
        return this;
    }

    @Override
    public MutableRecordModel add(String ... values) throws SchemaViolationException {
        if (values.length != 0) {
            RecordImpl schemaRecord = this.schema().lastRecord();
            if (this.theModel.size() > schemaRecord.getIndex()) {
                MutableRecordModelImpl.addValuesToRecord(schemaRecord, this.theModel.get(this.theModel.size() - 1), values);
            } else {
                throw new SchemaViolationException("Variable record '" + schemaRecord.getName() + "' has no occurrences to add a field to");
            }
        }
        return this;
    }

    private static void addValuesToRecord(RecordImpl schemaRecord, List<String> record, String ... values) throws SchemaViolationException {
        int current;
        FieldImpl schemaField = schemaRecord.lastField();
        if (!schemaField.isVariable()) {
            throw new SchemaViolationException("Final field of record '" + schemaRecord.getName() + "' is not variable");
        }
        int max = schemaField.getMax();
        if (max != -1 && (current = record.size() - schemaField.getIndex()) + values.length > max) {
            throw new SchemaViolationException("Adding values would exceed maximum number of field occurrences");
        }
        ArrayList<String> valueList = new ArrayList<String>(values.length);
        for (String value : values) {
            valueList.add(schemaField.normalize(value));
        }
        record.addAll(valueList);
    }

    @Override
    public MutableRecordModel addRecord() throws SchemaViolationException {
        RecordImpl schemaRecord = this.schema().lastRecord();
        if (!schemaRecord.isVariable()) {
            throw new SchemaViolationException("Record '" + schemaRecord.getName() + "' is not variable");
        }
        int max = schemaRecord.getMax();
        if (max != -1 && this.theModel.size() - schemaRecord.getIndex() >= max) {
            throw new SchemaViolationException("Record '" + schemaRecord.getName() + "' already has maximum number of occurrences");
        }
        this.theModel.add(schemaRecord.createModel());
        return this;
    }

    @Override
    public MutableRecordModel removeRecord(int index) throws SchemaViolationException, IndexOutOfBoundsException {
        RecordImpl schemaRecord = this.schema().lastRecord();
        if (!schemaRecord.isVariable()) {
            throw new SchemaViolationException("Record '" + schemaRecord.getName() + "' is not variable");
        }
        int actualIndex = MutableRecordModelImpl.resolveRecordIndex(schemaRecord, this.theModel, index);
        if (this.theModel.size() - schemaRecord.getIndex() - 1 < schemaRecord.getMin()) {
            throw new SchemaViolationException("Removing an occurrence of record '" + schemaRecord.getName() + "' would violate the minimum number of occurrences");
        }
        this.theModel.remove(actualIndex);
        return this;
    }

    @Override
    public MutableRecordModel removeField(String recordName, int recordIndex, int fieldIndex) throws SchemaViolationException, IndexOutOfBoundsException {
        RecordImpl schemaRecord = this.schema().getRecord(recordName);
        List<String> record = this.getRecord(schemaRecord, recordIndex);
        FieldImpl schemaField = schemaRecord.lastField();
        if (!schemaField.isVariable()) {
            throw new SchemaViolationException("Field '" + schemaField.getName() + "' is not a variable field");
        }
        int actualFieldIndex = MutableRecordModelImpl.resolveFieldIndex(schemaField, record, fieldIndex);
        if (record.size() - schemaField.getIndex() - 1 < schemaField.getMin()) {
            throw new SchemaViolationException("Field '" + schemaField.getName() + "' occurrence cannot be removed as it already has minimum number of occurrences");
        }
        record.remove(actualFieldIndex);
        return this;
    }

    @Override
    public MutableRecordModel clearVariableRecords() {
        RecordImpl schemaRecord = this.schema().lastRecord();
        int desiredSize = schemaRecord.getIndex() + schemaRecord.getMin();
        while (this.theModel.size() > desiredSize) {
            this.theModel.remove(this.theModel.size() - 1);
        }
        return this;
    }

    @Override
    public MutableRecordModel clearVariableFields(String recordName, int recordIndex) throws SchemaViolationException, IndexOutOfBoundsException {
        RecordImpl schemaRecord = this.schema().getRecord(recordName);
        List<String> record = this.getRecord(schemaRecord, recordIndex);
        FieldImpl schemaField = schemaRecord.lastField();
        int desiredSize = schemaField.getIndex() + schemaField.getMin();
        while (record.size() > desiredSize) {
            record.remove(record.size() - 1);
        }
        return this;
    }
}

