/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl.model;

import com.pushtechnology.diffusion.datatype.recordv2.RecordV2;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2Impl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2Utils;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.FieldImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.RecordImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.SchemaImpl;
import com.pushtechnology.diffusion.datatype.recordv2.model.RecordModel;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import com.pushtechnology.diffusion.utils.tuple.Pair;
import java.util.List;

public abstract class AbstractRecordModel
implements RecordModel {
    private final SchemaImpl theSchema;

    public AbstractRecordModel(SchemaImpl schema) {
        this.theSchema = schema;
    }

    protected final SchemaImpl schema() {
        return this.theSchema;
    }

    @Override
    public final RecordV2 asValue() {
        return new RecordV2Impl(RecordV2Utils.recordsToBytes(this.model()));
    }

    @Override
    public final String get(String recordName, int recordIndex, String fieldName, int fieldIndex) throws SchemaViolationException, IndexOutOfBoundsException {
        RecordImpl schemaRecord = this.schema().getRecord(recordName);
        List<String> record = this.getRecord(schemaRecord, recordIndex);
        FieldImpl schemaField = schemaRecord.getField(fieldName);
        return record.get(AbstractRecordModel.resolveFieldIndex(schemaField, record, fieldIndex));
    }

    @Override
    public String get(String key) throws SchemaViolationException, IndexOutOfBoundsException, IllegalArgumentException, NumberFormatException {
        Key parsedKey = this.parseKey(key);
        return this.get(parsedKey.getRecordName(), parsedKey.getRecordIndex(), parsedKey.getFieldName(), parsedKey.getFieldIndex());
    }

    @Override
    public int recordCount(String recordName) throws SchemaViolationException {
        RecordImpl schemaRecord = this.schema().getRecord(recordName);
        if (schemaRecord.isVariable()) {
            return this.model().size() - schemaRecord.getIndex();
        }
        return schemaRecord.getMin();
    }

    @Override
    public int fieldCount(String recordName, int recordIndex, String fieldName) throws SchemaViolationException, IndexOutOfBoundsException {
        RecordImpl schemaRecord = this.schema().getRecord(recordName);
        FieldImpl schemaField = schemaRecord.getField(fieldName);
        if (schemaField.isVariable()) {
            List<String> record = this.getRecord(schemaRecord, recordIndex);
            return record.size() - schemaField.getIndex();
        }
        return schemaField.getMin();
    }

    protected final List<String> getRecord(RecordImpl schemaRecord, int index) {
        List<List<String>> model = this.model();
        return model.get(AbstractRecordModel.resolveRecordIndex(schemaRecord, model, index));
    }

    protected final Key parseKey(String key) throws IllegalArgumentException {
        Pair<String, Integer> keyParts;
        int recordIndex;
        String recordName;
        String fieldKey;
        String[] parts = key.split("\\.", 2);
        if (parts.length == 1) {
            fieldKey = parts[0];
            RecordImpl record = this.theSchema.firstRecord();
            recordName = record.getName();
            recordIndex = 0;
        } else {
            keyParts = AbstractRecordModel.parseKeyPart(parts[0].trim());
            recordName = keyParts.getFirst();
            recordIndex = keyParts.getSecond();
            fieldKey = parts[1];
        }
        keyParts = AbstractRecordModel.parseKeyPart(fieldKey);
        return new Key(recordName, recordIndex, keyParts.getFirst(), keyParts.getSecond());
    }

    private static Pair<String, Integer> parseKeyPart(String keyPart) throws IllegalArgumentException, NumberFormatException {
        if (keyPart.length() == 0) {
            throw new IllegalArgumentException("No name specified");
        }
        int openIndex = keyPart.indexOf(40);
        if (openIndex == -1) {
            return Pair.of(keyPart, 0);
        }
        if (openIndex == 0) {
            throw new IllegalArgumentException("No name specified");
        }
        int closeIndex = keyPart.indexOf(41);
        if (closeIndex == -1 || closeIndex < openIndex) {
            throw new IllegalArgumentException("'(' found without closing ')'");
        }
        if (closeIndex < keyPart.length() - 1) {
            throw new IllegalArgumentException("Characters found after closing ')'");
        }
        return Pair.of(keyPart.substring(0, openIndex), Integer.parseInt(keyPart.substring(openIndex + 1, closeIndex)));
    }

    protected abstract List<List<String>> model();

    static int resolveRecordIndex(RecordImpl record, List<List<String>> records, int index) {
        int actualIndex = record.getAbsoluteIndex(index);
        if (actualIndex > records.size() - 1) {
            throw new IndexOutOfBoundsException("Index '" + index + "' does not have a matching entry for variable occurrence record '" + record.getName());
        }
        return actualIndex;
    }

    static int resolveFieldIndex(FieldImpl field, List<String> fields, int index) {
        int actualIndex = field.getAbsoluteIndex(index);
        if (actualIndex > fields.size() - 1) {
            throw new IndexOutOfBoundsException("Index '" + index + "' does not have a matching entry for variable occurrence field '" + field.getName());
        }
        return actualIndex;
    }

    static final class Key {
        private final String recordName;
        private final int recordIndex;
        private final String fieldName;
        private final int fieldIndex;

        private Key(String recordName, int recordIndex, String fieldName, int fieldIndex) {
            this.recordName = recordName;
            this.recordIndex = recordIndex;
            this.fieldName = fieldName;
            this.fieldIndex = fieldIndex;
        }

        String getRecordName() {
            return this.recordName;
        }

        int getRecordIndex() {
            return this.recordIndex;
        }

        String getFieldName() {
            return this.fieldName;
        }

        int getFieldIndex() {
            return this.fieldIndex;
        }
    }
}

